package com.bxm.game.scene.common.core.prop;

/**
 * 道具-基类<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/28 15:46
 */
public class BaseProp implements Prop {

    /**
     * 道具对应的资产类型
     */
    protected final String assetType;
    /**
     * 是否已获得
     */
    protected boolean acquired;
    /**
     * 数量
     */
    protected final int propNum;
    /**
     * 可翻倍倍数
     */
    protected final Number multipleNum;
    /**
     * 得到道具的行为
     */
    protected final String act;

    public BaseProp(String assetType, boolean acquired, int propNum, Number multipleNum, String act) {
        this.assetType = assetType;
        this.acquired = acquired;
        this.propNum = propNum;
        this.multipleNum = multipleNum;
        this.act = act;
    }

    @Override
    public boolean acquired() {
        return this.acquired;
    }

    @Override
    public int propNum() {
        return this.propNum;
    }

    @Override
    public String getAssetType() {
        return this.assetType;
    }

    @Override
    public Number multipleNum() {
        return this.multipleNum;
    }

    @Override
    public String getAct() {
        return this.act;
    }
}
