package com.bxm.game.scene.common.core.prop;

/**
 * 道具授予
 *
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public interface PropGrantor {

    /**
     * 授予道具数量，根据道具信息决定是否翻倍
     * @param prop 道具
     * @param isMultiple 是否翻倍处理
     * @return
     */
    boolean grant(Prop prop, boolean isMultiple);

    /**
     * 授予单额道具数量，将道具变成资产保存到用户资产中。
     * @param prop 道具
     */
    boolean single(Prop prop);

    /**
     * 授予翻倍道具数量，将道具变成资产保存到用户资产中。
     * @param prop 道具
     */
    boolean multiple(Prop prop);
}
