package com.bxm.game.scene.common.core.prop.event;

import java.util.EventObject;

import lombok.Getter;

/**
 * 道具到账事件
 *
 * @author allen
 * @date 2021-01-13
 * @since 1.0
 */
@Getter
public class PropGrantEvent extends EventObject {

    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_MULTIPLE = 2;

    private final int type;
    private final String assetType;
    private final long after;

    public PropGrantEvent(Object source, int type, String assetType, long after) {
        super(source);
        this.type = type;
        this.assetType = assetType;
        this.after = after;
    }
}
