package com.bxm.game.scene.common.core.prop.impl;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropBuilder;

/**
 * @author allen
 * @date 2021-01-11
 * @since 1.0
 */
@ConditionalOnMissingBean(PropBuilder.class)
public class DefaultPropBuilderImpl implements PropBuilder {

    @Override
    public Prop rebuild(String assetType, int propNum, Number multipleNum, String act, String sceneType) {
        return new Prop() {
            @Override
            public String getAssetType() {
                return assetType;
            }

            @Override
            public int propNum() {
                return propNum;
            }

            @Override
            public Number multipleNum() {
                return multipleNum;
            }

            @Override
            public String getAct() {
                return act;
            }

            @Override
            public String getSceneType() {
                return sceneType;
            }
        };
    }
}
