package com.bxm.game.scene.common.core.prop.impl;

import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.PropService;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
@Slf4j
@ConditionalOnMissingBean(PropService.class)
public class DefaultPropServiceImpl implements PropService {

    private final PropDao propDao;

    public DefaultPropServiceImpl(PropDao propDao) {
        this.propDao = propDao;
    }

    @Override
    public boolean saveTakeLog(AcquiredPropLog log) {
        return propDao.saveTakeLog(log);
    }

    @Override
    public AcquiredPropLog getTakeLog(String id) {
        return propDao.getTakeLog(id);
    }
}
