package com.bxm.game.scene.common.core.scene;

import java.util.Map;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
@Slf4j
public class SceneServiceFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<String, com.bxm.game.scene.common.core.scene.SceneService> map = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, com.bxm.game.scene.common.core.scene.SceneService> beans = applicationContext.getBeansOfType(com.bxm.game.scene.common.core.scene.SceneService.class);
        for (com.bxm.game.scene.common.core.scene.SceneService service : beans.values()) {
            map.put(service.getSceneType(), service);
            log.info("Registering SceneService to Factory: {}", service);
        }
    }

    public com.bxm.game.scene.common.core.scene.SceneService get(String sceneType) {
        return map.get(sceneType);
    }
}
