package com.bxm.game.scene.common.core.scene.acquire;

import java.util.EventObject;

import com.bxm.game.scene.common.core.scene.DefaultSceneType;

import lombok.Getter;

/**
 * 道具通过 {@link DefaultSceneType#ACQUIRE} 场景获取后触发的事件。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class AcquiredSceneEvent extends EventObject {

    private final AcquireSceneRequest request;
    private final AcquireSceneResponse response;
    /**
     * 事件源场景，如：signin等
     */
    private final String sceneType;

    public AcquiredSceneEvent(Object source, AcquireSceneRequest request, AcquireSceneResponse response,
                              String sceneType) {
        super(source);
        this.request = request;
        this.response = response;
        this.sceneType = sceneType;
    }
}
