package com.bxm.game.scene.common.core.scene.listeners;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.game.scene.common.core.user.UserActiveService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * 发放道具后，设置用户为活跃。
 *
 * @author allen
 * @date 2021-01-28
 */
@Slf4j
@Order(Ordered.HIGHEST_PRECEDENCE)
public class ActiveListener implements EventListener<AcquiredPropEvent> {

    private final UserActiveService userActiveService;

    public ActiveListener(UserActiveService userActiveService) {
        this.userActiveService = userActiveService;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        userActiveService.active(event);
    }
}
