package com.bxm.game.scene.common.core.scene.multiple;

import java.util.EventObject;

import com.bxm.game.scene.common.core.scene.DefaultSceneType;

import lombok.Getter;

/**
 * 道具通过 {@link DefaultSceneType#MULTIPLE} 场景获取后触发的事件。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class MultipleSceneEvent extends EventObject {

    private final MultipleSceneRequest request;
    private final MultipleSceneResponse response;
    /**
     * 事件源场景，如：signin等
     */
    private final String sceneType;

    public MultipleSceneEvent(Object source, MultipleSceneRequest request, MultipleSceneResponse response,
                              String sceneType) {
        super(source);
        this.request = request;
        this.response = response;
        this.sceneType = sceneType;
    }
}
