package com.bxm.game.scene.common.core.scene.schema;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

import com.bxm.game.scene.common.core.fun.config.SceneConfigFetcher;
import com.bxm.game.scene.common.core.scene.DefaultSceneType;

import lombok.extern.slf4j.Slf4j;

/**
 * 框架配置<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/22 11:16
 */
@Slf4j
@ConditionalOnBean(SchemaConfigService.class)
public class SchemaSceneServiceImpl implements SceneConfigFetcher<SchemaSceneConfigRequest, SchemaSceneConfigResponse> {

    protected final SchemaConfigService schemaConfigService;

    public SchemaSceneServiceImpl(SchemaConfigService schemaConfigService){
        this.schemaConfigService = schemaConfigService;
    }

    @Override
    public String getSceneType() {
        return DefaultSceneType.SCHEMA;
    }

    @Override
    public Class<SchemaSceneConfigRequest> getConfigRequestClass() {
        return SchemaSceneConfigRequest.class;
    }

    @Override
    public SchemaSceneConfigResponse getConfig(SchemaSceneConfigRequest request) {
        return schemaConfigService.getConfig(request);
    }

}
