package com.bxm.game.scene.common.core.scene.signin;

import com.bxm.game.scene.common.core.scene.AbstractMaximumTimesOnDailySceneService;

import lombok.extern.slf4j.Slf4j;

/**
 * 签到<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/22 11:16
 */
@Slf4j
public abstract class AbstractSigninSceneServiceImpl<R extends SigninSceneRequest, T extends SigninSceneResponse>
        extends AbstractMaximumTimesOnDailySceneService<R, T> {

    /**
     * 获取新的响应对象
     *
     * @return
     */
    protected abstract T getInstanceResponse(R request);

    /**
     * 签到天数字段名
     *
     * @param mark 标识
     * @param days 天数
     * @return
     */
    protected String getField(String mark, String days){
        return new StringBuilder(mark).append('_').append(days).toString();
    }

}
