package com.bxm.game.scene.common.core.scene.signin.week;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.bxm.game.scene.common.core.DefaultConsts;
import com.bxm.game.scene.common.core.DefaultDataField;
import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.scene.DefaultSceneType;
import com.bxm.game.scene.common.core.scene.signin.AbstractSigninSceneServiceImpl;
import com.bxm.game.scene.common.core.scene.signin.SigninSceneRequest;
import com.bxm.game.scene.common.core.scene.signin.SigninSceneResponse;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.util.WeekCNHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 周签<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/22 11:16
 */
@Slf4j
public abstract class AbstractWeekSigninSceneServiceImpl<R extends SigninSceneRequest, T extends SigninSceneResponse>
        extends AbstractSigninSceneServiceImpl<R, T> implements WeekSigninService<R, T> {

    protected final WeekSigninConfigService signinConfigService;
    protected final DefaultTimeBoundService defaultTimeBoundService;
    protected final int ttl;

    public AbstractWeekSigninSceneServiceImpl(WeekSigninConfigService signinConfigService,
                                              DefaultTimeBoundService defaultTimeBoundService){
        this.signinConfigService = signinConfigService;
        this.defaultTimeBoundService = defaultTimeBoundService;
        ttl = DefaultConsts.TTL_WEEKS;
    }

    @Override
    protected boolean isAbort(R request, Map<Object, Object> attach) {
        Date currentDate = new Date();
        int daysOfWeek = WeekCNHelper.orderDaysOfWeek(currentDate);
        if(null != request && null != request.getDays()){
            if(request.getDays() < 1){
                request.setDays(1);
            }else if(request.getDays() > 7){
                request.setDays(7);
            }
            if(request.getDays() > daysOfWeek){
                // 不允许未来签到
                return true;
            }
        }
        attach.put(DefaultConsts.Attach.F_1, daysOfWeek);
        String weekOfYear = WeekCNHelper.getWeekOfYear(currentDate);
        attach.put(DefaultConsts.Attach.F_2, weekOfYear);
        return super.isAbort(request, attach);
    }

    @Override
    public boolean todaySignin() {
        return todayAtomicService.hGet(DefaultRedisKeyType.FREQ, getSceneType()) > 0;
    }

    @Override
    protected Prop takeProp(R request, Map<Object, Object> attach) {
        int daysOfWeek = (int)attach.get(DefaultConsts.Attach.F_1);
        String weekOfYear = (String)attach.get(DefaultConsts.Attach.F_2);
        String siginType = getSceneType();

        String week = defaultTimeBoundService.hGet(DefaultRedisKeyType.SIGN,
                DefaultDataField.SIGNIN_WEEK, String.class);
        if(null == week || !week.equals(weekOfYear)){
            defaultTimeBoundService.hSet(DefaultRedisKeyType.SIGN,
                    DefaultDataField.SIGNIN_WEEK, weekOfYear, ttl);
            List<String> list = new ArrayList<>();
            for (int i = daysOfWeek+1; i <= 7; i++) {
                list.add(getField(siginType, String.valueOf(i)));
            }
            defaultTimeBoundService.hDel(DefaultRedisKeyType.SIGN, list.toArray(new String[]{}));
        }
        // 本周第几天（1~7表示周一 ~ 周日）
        int days;
        if(null != request && null != request.getDays()){
            days = request.getDays();
        }else{
            days = daysOfWeek;
        }
        // 签到或补签
        defaultTimeBoundService.hIncr(DefaultRedisKeyType.SIGN,
                getField(siginType, String.valueOf(days)), ttl);
        return signinConfigService.getProps(request.getAcquired(), days);
    }

    @Override
    protected T createResponse(R request, String id, Prop prop, Map<Object, Object> attach) {
        T response = getInstanceResponse(request);
        return response;
    }

    @Override
    public String getSceneType() {
        return DefaultSceneType.SIGNIN;
    }

}
