package com.bxm.game.scene.common.core.transfer;

import java.util.Map;

import com.bxm.game.scene.common.core.user.PermanentAtomicService;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import com.bxm.game.scene.common.core.bean.enums.DataTypeEnum;

/**
 * 数据转换器，可将原始存储在 {@link com.bxm.game.scene.common.core.user.BaseAtomicService} 的数据进行转换成期望的数据集。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 * @see com.bxm.game.scene.common.core.bean.vo.ArchiveVo#getToday()
 * @see com.bxm.game.scene.common.core.bean.vo.ArchiveVo#getPermanent()
 * @see TodayAtomicService#getAll()
 * @see PermanentAtomicService#getAll()
 */
public interface DataTransfer {

    /**
     * 转换数据
     * @param type 数据类型
     * @param source 原始数据
     * @return 转换后期望的数据集
     */
    Map<String, Object> transfer(DataTypeEnum type, Map<String, Object> source);
}
