package com.bxm.game.scene.common.core.user.dao;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;

import com.bxm.game.scene.common.core.DefaultConsts;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.warcar.utils.DateHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/20 18:36
 */
@Slf4j
@ConditionalOnMissingBean(UserDao.class)
public class EmptyUserDaoImpl implements UserDao {

    protected final int PERMANENT_DAYS = 180;
    protected final int DELAY_DAYS = 15;
    @Autowired(required = false)
    protected DefaultTimeBoundService defaultTimeBoundService;

    @Override
    public boolean handleAppContext(HttpServletRequest request, HttpServletResponse response, AppContext context) {
//        String uid = null;
//        if (StringUtils.isBlank(uid)) {
//            log.info("uid is blank,appid={},device={}", appid, device);
//            return error(response);
//        }
//        context.setUid(uid);
//
//        String cuid = null;
//        if (StringUtils.isBlank(cuid)) {
//            log.info("cuid is blank,appid={},device={}", appid, device);
//            return error(response);
//        }
//        context.setCuid(cuid);

        // 默认永久周期，15天不活跃则清空数据
        boundDays(context, -1, false);

        return true;
    }

    /**
     * 错误信息
     */
    protected boolean error(HttpServletResponse response){
        response.setStatus(HttpStatus.ACCEPTED.value());
        return false;
    }

    /**
     * 时效周期
     *
     * @param context 上下文
     * @param days 时效周期（天）
     * @param force 是否强制更新ttl
     */
    protected void boundDays(AppContext context, int days, boolean force){
        boundDays(context, days, DELAY_DAYS, force);
    }

    /**
     * 时效周期
     *
     * @param context 上下文
     * @param days 时效周期（天）
     * @param delayDays 用户不活跃时，保留时长（天）
     * @param force 是否强制更新ttl
     */
    protected void boundDays(AppContext context, int days, int delayDays, boolean force){
        if(days <= 0){
            days = PERMANENT_DAYS;
        }
        if(delayDays < DELAY_DAYS){
            delayDays = DELAY_DAYS;
        }
        boundSeconds(context, DefaultConsts.TTL_DAYS * days,
                DefaultConsts.TTL_DAYS * delayDays, force, DateHelper.PATTERN_STR8);
    }

    /**
     * 时效周期
     *
     * @param context 上下文
     * @param cycleTimes 时效周期（秒）
     * @param delay 用户不活跃时，保留时长（秒）。</br>
     *              为防止锚定日期未变更，而时效数据已过期的极端情况，适当地延长了时效数据的有效时长。
     * @param force 是否强制更新ttl
     * @param format 锚定日期格式
     */
    private void boundSeconds(AppContext context, int cycleTimes, int delay, boolean force, String format){
        String boundAnchor = defaultTimeBoundService.saveGetAnchor(cycleTimes, delay, force,
                (anchor) -> {
                    long limitTime = DateUtils.addSeconds(DateHelper.parse(anchor, format),
                            cycleTimes).getTime();
                    return System.currentTimeMillis() > limitTime;
                },
                ()-> DateHelper.format(format)
        );
        context.setBoundAnchor(boundAnchor);
        long limitTime = DateUtils.addSeconds(DateHelper.parse(boundAnchor, format),
                cycleTimes+delay).getTime();
        context.setBoundLimit(limitTime);
    }

}
