package com.bxm.game.scene.common.core.user.redis;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.bean.enums.RedisStorageEnum;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户时效性 - 支持ttl可变<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/22 9:49
 */
@Slf4j
@ConditionalOnMissingBean(DefaultTimeBoundService.class)
public class RedisDefaultTimeBoundServiceImpl extends BaseTimeBoundServiceImpl implements DefaultTimeBoundService {

    public RedisDefaultTimeBoundServiceImpl(AppConfigFetcher appConfigFetcher, Key key,
                                            @Qualifier("jedisFetcher") Fetcher fetcher,
                                            @Qualifier("jedisUpdater") Updater updater,
                                            @Qualifier("jedisCounter") Counter counter) {
        super(appConfigFetcher, key, fetcher, updater, counter);
    }

    @Override
    public Map<String, RedisStorageEnum> getTypeMap() {
        Map<String, RedisStorageEnum> map = new HashMap<>();
        map.put(DefaultRedisKeyType.FREQ, RedisStorageEnum.HASH);
        return map;
    }

    @Override
    public KeyGenerator getKey(String type){
        if(IGNORE_BOUND_ANCHOR.contains(type) || null == AppContext.get().getBoundAnchor()) {
            return this.key.getTimeBoundForUser(null, type,
                    appConfigFetcher.defaultBoundWithAppForUser(type));
        }else{
            return this.key.getTimeBoundForUser(AppContext.get().getBoundAnchor(), type,
                    appConfigFetcher.defaultBoundWithAppForUser(type));
        }
    }
}
