package com.bxm.game.scene.common.core.user.redis;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultConsts;
import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.bean.enums.RedisStorageEnum;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户时效性 - 当日<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/22 9:49
 */
@Slf4j
@ConditionalOnMissingBean(TodayAtomicService.class)
public class RedisTodayAtomicServiceImpl extends BaseAtomicServiceImpl implements TodayAtomicService {

    public RedisTodayAtomicServiceImpl(AppConfigFetcher appConfigFetcher, Key key,
                                       @Qualifier("jedisFetcher") Fetcher fetcher,
                                       @Qualifier("jedisUpdater") Updater updater,
                                       @Qualifier("jedisCounter") Counter counter) {
        super(appConfigFetcher, key, fetcher, updater, counter);
    }

    @Override
    public Map<String, RedisStorageEnum> getTypeMap() {
        Map<String, RedisStorageEnum> map = new HashMap<>();
        map.put(DefaultRedisKeyType.FREQ, RedisStorageEnum.HASH);
        return map;
    }

    @Override
    public KeyGenerator getKey(String type) {
        return this.key.getTodayForUser(type, appConfigFetcher.todayWithAppForUser(type));
    }

    @Override
    public final int getTtl() {
        return DefaultConsts.TTL_TODAY;
    }
}
