package com.bxm.game.scene.common.core.user.redis;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.fun.system.RuntimeClock;
import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.UserActiveService;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户活跃服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/28 17:01
 */
@Slf4j
@ConditionalOnMissingBean(UserActiveService.class)
public class RedisUserActiveServiceImpl implements UserActiveService {

    protected final DefaultTimeBoundService defaultTimeBoundService;
    protected final RuntimeClock runtimeClock;

    public RedisUserActiveServiceImpl(DefaultTimeBoundService defaultTimeBoundService,
                                      RuntimeClock runtimeClock) {
        this.defaultTimeBoundService = defaultTimeBoundService;
        this.runtimeClock = runtimeClock;
    }

    @Override
    public void active() {
        defaultTimeBoundService.setbit(DefaultRedisKeyType.ACTIVE,
                runtimeClock.getRuntimeDays(), true);
    }

    @Override
    public void active(AcquiredPropEvent event) {
        defaultTimeBoundService.setbit(DefaultRedisKeyType.ACTIVE,
                runtimeClock.getRuntimeDays(), true);
    }

    @Override
    public long getActiveDays() {
        return defaultTimeBoundService.bitcount(DefaultRedisKeyType.ACTIVE);
    }

    @Override
    public void clean() {
        defaultTimeBoundService.del(DefaultRedisKeyType.ACTIVE);
    }
}
