package com.bxm.game.scene.common.core.user.redis;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Qualifier;

import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.user.UserRegisterService;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.cache.Fetcher;

import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

/**
 * 用户登记薄<br/>
 *
 * @author kerry.jiang
 * @date 2021/9/2 11:11
 */
@Slf4j
public class RedisUserRegisterServiceImpl implements UserRegisterService {

    private final Key key;
    private final Fetcher fetcher;

    public RedisUserRegisterServiceImpl(Key key, @Qualifier("jedisFetcher") Fetcher fetcher) {
        this.key = key;
        this.fetcher = fetcher;
    }

    @Override
    public void register() {
        String gcode = AppContext.get().getGameCode();
        String appid = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();

        int gcodeBucket = CommonHelper.getBuckets(gcode, Key.REGISTER_GAME_BUCKETS);
        int appidBucket = CommonHelper.getBuckets(appid, Key.REGISTER_APP_BUCKETS);
        int uidBucket = CommonHelper.getBuckets(uid, Key.REGISTER_USER_BUCKETS);
        JedisPool jedisPool = CommonHelper.getJedisPool(fetcher);
        double score = Double.valueOf(System.currentTimeMillis());
        try (Jedis jedis = jedisPool.getResource()) {
            Pipeline pipeline = jedis.pipelined();
            pipeline.zadd(key.getRegisterGames(gcodeBucket).generateKey(), score, gcode);
            pipeline.zadd(key.getRegisterApps(appidBucket).generateKey(), score, appid);
            pipeline.zadd(key.getRegisterUsers(uidBucket).generateKey(), score, uid);
            pipeline.syncAndReturnAll();
        }catch (Exception e){
            log.error("register error: appid={}, uid={}, e={}",
                    appid, uid, ExceptionUtils.getStackTrace(e));
        }
    }
}
