package com.bxm.game.scene.common.core.util;

import java.util.Calendar;
import java.util.Date;

import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;

import redis.clients.jedis.JedisPool;

/**
 * 公共辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/16 9:43
 */
public class CommonHelper {

    /**
     * 锚定日期为第一天，今日是第几天
     */
    public static int orderDays(){
        return orderDays(AppContext.get().getBoundAnchor(), new Date());
    }

    /**
     * startYmd日期为第一天，end是第几天
     * @param startYmd {yyyyMMdd}格式的日期
     * @param end end 日期
     */
    public static int orderDays(String startYmd, Date end){
        Date start = DateHelper.parse(startYmd, DateHelper.PATTERN_STR8);
        return orderDays(start, end);
    }

    /**
     * start日期为第一天，end是第几天
     * @param start 日期
     * @param end 日期
     */
    public static int orderDays(Date start, Date end){
        Calendar c1 = Calendar.getInstance();
        c1.setTime(start);
        c1.set(Calendar.HOUR_OF_DAY, 0);
        c1.set(Calendar.MINUTE, 0);
        c1.set(Calendar.SECOND, 0);
        c1.set(Calendar.MILLISECOND, 0);

        Calendar c2 = Calendar.getInstance();
        c2.setTime(end);
        c2.set(Calendar.HOUR_OF_DAY, 0);
        c2.set(Calendar.MINUTE, 0);
        c2.set(Calendar.SECOND, 0);
        c2.set(Calendar.MILLISECOND, 0);

        return (int)Math.round((c2.getTimeInMillis() - c1.getTimeInMillis()) / 86400000D) + 1;
    }

    /**
     * 根据hashcode的绝对值分桶
     * @param str 字符串
     * @param dividend 取模变量
     * @return
     */
    public static int getBuckets(String str, int dividend){
        return Math.abs(str.hashCode()) % dividend;
    }

    /**
     * 获取JedisPool对象<br/>
     *
     * @param fetcher
     * @return 
     */
    public static JedisPool getJedisPool(Fetcher fetcher) {
        return getJedisPool(fetcher.getClientOriginal());
    }

    /**
     * 获取JedisPool对象<br/>
     *
     * @param updater
     * @return
     */
    public static JedisPool getJedisPool(Updater updater) {
        return getJedisPool(updater.getClientOriginal());
    }

    /**
     * 获取JedisPool对象<br/>
     *
     * @param counter
     * @return
     */
    public static JedisPool getJedisPool(Counter counter) {
        return getJedisPool(counter.getClientOriginal());
    }

    /**
     * 获取JedisPool对象<br/>
     */
    private static JedisPool getJedisPool(Object original) {
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool) original;
    }

}
