package com.bxm.game.scene.common.core.web;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.fun.header.RequestHeaderHandler;
import com.bxm.game.scene.common.core.web.interceptor.AppContextInterceptor;
import com.bxm.game.scene.common.core.web.interceptor.AppStatusInterceptor;
import com.bxm.game.scene.common.core.user.UserRegisterService;
import com.bxm.game.scene.common.core.user.dao.UserDao;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class GlobalMvcConfigurer implements WebMvcConfigurer {

    private final AppConfigFetcher appConfigFetcher;
    private final RequestHeaderHandler requestHeaderHandler;
    private final UserDao userDao;
    private final UserRegisterService userRegisterService;

    public GlobalMvcConfigurer(AppConfigFetcher appConfigFetcher,
                               RequestHeaderHandler requestHeaderHandler, UserDao userDao,
                               UserRegisterService userRegisterService) {
        this.appConfigFetcher = appConfigFetcher;
        this.requestHeaderHandler = requestHeaderHandler;
        this.userDao = userDao;
        this.userRegisterService = userRegisterService;
    }

    @Bean
    public AppContextInterceptor appContextInterceptor() {
        return new AppContextInterceptor(userDao, requestHeaderHandler,
                userRegisterService, appConfigFetcher);
    }

    @Bean
    public AppStatusInterceptor appStatusInterceptor() {
        return new AppStatusInterceptor(appConfigFetcher);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludePathPatterns = appConfigFetcher.excludePathPatternsOfGlobal();
        registry.addInterceptor(appStatusInterceptor())
                .order(Ordered.HIGHEST_PRECEDENCE)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns);

        registry.addInterceptor(appContextInterceptor())
                .order(Ordered.HIGHEST_PRECEDENCE + 1)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns)
                .excludePathPatterns(appConfigFetcher.excludePathPatternsOfAppContextInterceptor());
    }

    @Bean
    public CorsFilter corsFilter() {
        // 有 Interceptor 拦截器的情况下必须使用这种方式，不能使用该接口的 #addCorsMappings，否则可能因为顺序问题而跨域设置无效。
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin(CorsConfiguration.ALL);
        configuration.addAllowedHeader(CorsConfiguration.ALL);
        configuration.addAllowedMethod(CorsConfiguration.ALL);
        configuration.setAllowCredentials(true);

        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return new CorsFilter(source);
    }
}
