package com.bxm.game.scene.common.core.web.controllers;

import javax.servlet.http.HttpServletRequest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.game.scene.common.core.fun.config.SceneConfigFetcher;
import com.bxm.game.scene.common.core.fun.config.SceneConfigServiceFactory;

import lombok.extern.slf4j.Slf4j;

/**
 * 配置信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 17:38
 */
@Slf4j
@RestController
@RequestMapping("/config")
public class ConfigController {

    @Autowired
    private SceneConfigServiceFactory factory;

    /**
     * 根据场景返回不同的配置信息
     *
     * @param sceneType
     * @return
     */
    @RequestMapping("/info/{sceneType}")
    public ResponseEntity<Object> info(@PathVariable("sceneType") String sceneType,
                                            HttpServletRequest request){
        Map<String, Object> paramMap = getParamMap(request);
        final SceneConfigFetcher configFetcher = factory.get(sceneType);
        if(null == configFetcher){
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.ok(configFetcher.getConfig(paramMap));
    }

    /**
     * 获取httpRequest的参数
     */
    private Map<String, Object> getParamMap(HttpServletRequest request) {
        Map<String, Object> map = new HashMap<>();
        if(MapUtils.isEmpty(request.getParameterMap())){
            return map;
        }
        Set<Map.Entry<String, String[]>> entrySet = request.getParameterMap().entrySet();
        for (Map.Entry<String, String[]> entry : entrySet) {
            String[] arr = entry.getValue();
            if(null == arr || arr.length < 1){
                continue;
            }

            StringBuilder result = new StringBuilder();
            if(arr.length == 1){
                result.append(arr[0]);
            }else{
                for (int i = 0; i < arr.length; i++) {
                    result.append(arr[i]);
                    if (i < arr.length - 1) {
                        result.append(",");
                    }
                }
            }
            map.put(entry.getKey(), result);
        }
        return map;
    }
}
