package com.bxm.game.scene.common.core.web.controllers;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.ErrCode;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.bean.storage.StorageRequest;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.TodayAtomicService;

import lombok.extern.slf4j.Slf4j;

/**
 * 存储信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 17:38
 */
@Slf4j
@RestController
@RequestMapping("/storage")
public class StorageController {

    @Autowired
    private TodayAtomicService todayAtomicService;
    @Autowired
    private DefaultTimeBoundService defaultTimeBoundService;

    /**
     * 存储信息
     *
     * @param request 存储信息
     * @return
     */
    @PostMapping("/today")
    public ResponseEntity<Boolean> todaySet(@RequestBody StorageRequest request){
        if(StringUtils.isBlank(request.getKey()) || StringUtils.isBlank(request.getValue())){
            throw new GameException(ErrCode.BAD_REQUEST);
        }
        todayAtomicService.hSet(DefaultRedisKeyType.STORAGE, request.getKey(), request.getValue());
        return ResponseEntity.ok(Boolean.TRUE);
    }

    /**
     * 获取信息
     *
     * @param key 键
     * @return
     */
    @GetMapping("/today")
    public ResponseEntity<Map> todayGet(@RequestParam("key") String key){
        Map map = new HashMap<>();
        map.put("key", key);
        map.put("value", todayAtomicService.hGet(DefaultRedisKeyType.STORAGE, key, String.class));
        return ResponseEntity.ok(map);
    }

    /**
     * 存储信息
     *
     * @param request 存储信息
     * @return
     */
    @PostMapping("/bound")
    public ResponseEntity<Boolean> boundSet(@RequestBody StorageRequest request){
        if(StringUtils.isBlank(request.getKey()) || StringUtils.isBlank(request.getValue())){
            throw new GameException(ErrCode.BAD_REQUEST);
        }
        defaultTimeBoundService.hSet(DefaultRedisKeyType.STORAGE, request.getKey(), request.getValue());
        return ResponseEntity.ok(Boolean.TRUE);
    }

    /**
     * 获取信息
     *
     * @param key 键
     * @return
     */
    @GetMapping("/bound")
    public ResponseEntity<Map> boundGet(@RequestParam("key") String key){
        Map map = new HashMap<>();
        map.put("key", key);
        map.put("value", defaultTimeBoundService.hGet(DefaultRedisKeyType.STORAGE, key, String.class));
        return ResponseEntity.ok(map);
    }
}
