package com.bxm.game.scene.common.core.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.HandlerInterceptor;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.ErrCode;

import lombok.extern.slf4j.Slf4j;

/**
 * 应用状态拦截器，如果状态非开放，那么所以的请求将会被拦截，并返回 {@link ErrCode#CLOSED}。
 *
 * @author allen
 * @date 2020-12-22
 * @since 1.0
 */
@Slf4j
public class AppStatusInterceptor implements HandlerInterceptor {

    private final AppConfigFetcher appConfigFetcher;

    public AppStatusInterceptor(AppConfigFetcher appConfigFetcher) {
        this.appConfigFetcher = appConfigFetcher;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!appConfigFetcher.isOpening()) {
            response.setStatus(ErrCode.CLOSED.getStatusCode());
            return false;
        }
        return true;
    }
}
