/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public final class Key {
    public static final int REGISTER_GAME_BUCKETS = 10;
    public static final int REGISTER_APP_BUCKETS = 10;
    public static final int REGISTER_USER_BUCKETS = 1000;
    private final AppConfigFetcher appConfigFetcher;

    public Key(AppConfigFetcher appConfigFetcher) {
        this.appConfigFetcher = appConfigFetcher;
    }

    public KeyGenerator generator(String ... keys) {
        return this.generator(true, keys);
    }

    public KeyGenerator generator(boolean onNamespace, String ... keys) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game"});
        if (onNamespace) {
            list.add(this.appConfigFetcher.namespace());
        }
        list.addAll(Arrays.asList(keys));
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getPermanentForUser(String type) {
        return this.getPermanentForUser(type, true);
    }

    public KeyGenerator getPermanentForUser(String type, boolean withApp) {
        return this.getPermanentForUser(AppContext.get().getGameCode(), AppContext.get().getAppId(), AppContext.get().getUid(), type, withApp);
    }

    public KeyGenerator getPermanentForUser(String gameCode, String appid, String uid, String type, boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "user", "0"});
        list.add(gameCode);
        if (withApp) {
            list.add(appid);
        }
        list.add(uid);
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTodayForUser(String type) {
        return this.getTodayForUser(type, true);
    }

    public KeyGenerator getTodayForUser(String type, boolean withApp) {
        return this.getTodayForUser(AppContext.get().getGameCode(), AppContext.get().getAppId(), AppContext.get().getUid(), type, withApp, DateHelper.getDate());
    }

    public KeyGenerator getTodayForUser(String gameCode, String appid, String uid, String type, boolean withApp, String ymd) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "user", ymd});
        list.add(gameCode);
        if (withApp) {
            list.add(appid);
        }
        list.add(uid);
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTodayForGame(String type) {
        return this.getTodayForGame(type, true);
    }

    public KeyGenerator getTodayForGame(String type, boolean withApp) {
        return this.getTodayForGame(AppContext.get().getGameCode(), AppContext.get().getAppId(), type, withApp, DateHelper.getDate());
    }

    public KeyGenerator getTodayForGame(String gameCode, String appid, String type, boolean withApp, String ymd) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "game", ymd});
        list.add(gameCode);
        if (withApp) {
            list.add(appid);
        }
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTemporaryForUser(String type) {
        return this.getTemporaryForUser(type, true);
    }

    public KeyGenerator getTemporaryForUser(String type, boolean withApp) {
        return this.getTemporaryForUser(AppContext.get().getGameCode(), AppContext.get().getAppId(), AppContext.get().getUid(), type, withApp);
    }

    public KeyGenerator getTemporaryForUser(String gameCode, String appid, String uid, String type, boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "temporary"});
        list.add(gameCode);
        if (withApp) {
            list.add(appid);
        }
        list.add(uid);
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTimeBoundForUser(String anchor, String type) {
        return this.getTimeBoundForUser(anchor, type, true);
    }

    public KeyGenerator getTimeBoundForUser(String anchor, String type, boolean withApp) {
        return this.getTimeBoundForUser(AppContext.get().getGameCode(), AppContext.get().getAppId(), AppContext.get().getUid(), anchor, type, withApp);
    }

    public KeyGenerator getTimeBoundForUser(String gameCode, String appid, String uid, String anchor, String type, boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "bound"});
        if (null != anchor) {
            list.add(anchor);
        }
        list.add(gameCode);
        if (withApp) {
            list.add(appid);
        }
        list.add(uid);
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getJobLock(String jobName) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "lock", jobName});
    }

    public KeyGenerator getRegisterGames(int bucket) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "register", "games", bucket});
    }

    public KeyGenerator getRegisterApps(int bucket) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "register", "apps", bucket});
    }

    public KeyGenerator getRegisterUsers(int bucket) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "register", "users", AppContext.get().getAppId(), bucket});
    }
}

