/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.api.interactive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.game.scene.common.core.api.interactive.InteractiveUserData;
import com.bxm.game.scene.common.core.api.interactive.InteractiveUserDataRequest;
import com.bxm.game.scene.common.core.api.interactive.InteractiveUserDataService;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class EmptyInteractiveUserDataServiceImpl
implements InteractiveUserDataService {
    private static final Logger log = LoggerFactory.getLogger(EmptyInteractiveUserDataServiceImpl.class);
    private final RestTemplate restTemplate;
    private final String getUserDataUrl;
    private final HttpHeaders headers = new HttpHeaders();

    public EmptyInteractiveUserDataServiceImpl(RestTemplate restTemplate, String apiUrl) {
        this.restTemplate = restTemplate;
        if (StringUtils.isBlank((CharSequence)apiUrl)) {
            throw new RuntimeException("apiUrl is empty");
        }
        this.getUserDataUrl = StringUtils.join((Object[])new String[]{apiUrl, "/openapi/udata"});
        this.headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
    }

    @Override
    public InteractiveUserData getUserData(InteractiveUserDataRequest request) {
        HttpEntity httpEntity = new HttpEntity((Object)request, (MultiValueMap)this.headers);
        return this.doPost(this.restTemplate, this.getUserDataUrl, httpEntity, new TypeReference<InteractiveUserData>(){});
    }

    private <T> T doPost(RestTemplate restTemplate, String url, HttpEntity httpEntity, TypeReference<T> typeReference) {
        ResponseEntity entity;
        try {
            entity = restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("doPost error: url={},paramJson={},e={}", new Object[]{url, JsonHelper.convert((Object)httpEntity.getBody()), ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        catch (Exception e) {
            log.error("doPost error: url={},paramJson={},e={}", new Object[]{url, JsonHelper.convert((Object)httpEntity.getBody()), ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (T)JSON.parseObject((String)((String)entity.getBody()), typeReference, (Feature[])new Feature[0]);
        }
        log.error("doPost fail: url={},httpStatus={},paramJson={},body={}", new Object[]{url, httpStatus.value(), JsonHelper.convert((Object)httpEntity.getBody()), entity.getBody()});
        return null;
    }
}

