/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.api.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.api.user.BxmUserMappingService;
import com.bxm.game.scene.common.core.bean.GameException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class EmptyBxmUserMappingServiceImpl
implements BxmUserMappingService {
    private static final Logger log = LoggerFactory.getLogger(EmptyBxmUserMappingServiceImpl.class);
    private final RestTemplate restTemplate;
    private final String getByUidUrl;
    private final String getByUidsUrl;
    private final String getByCuidUrl;
    private final String getAssetByCuidUrl;
    private final String getAssetLastByIdsUrl;

    public EmptyBxmUserMappingServiceImpl(RestTemplate restTemplate, String apiUrl) {
        this.restTemplate = restTemplate;
        if (StringUtils.isBlank((CharSequence)apiUrl)) {
            apiUrl = "http://gw-inner.bianxianmao.com/user-api";
        }
        this.getByUidUrl = StringUtils.join((Object[])new String[]{apiUrl, "/userMapping/getByUid"});
        this.getByUidsUrl = StringUtils.join((Object[])new String[]{apiUrl, "/userMapping/getMappingByUid"});
        this.getByCuidUrl = StringUtils.join((Object[])new String[]{apiUrl, "/userMapping/getByCuid"});
        this.getAssetByCuidUrl = StringUtils.join((Object[])new String[]{apiUrl, "/userMapping/getAssetByCuid"});
        this.getAssetLastByIdsUrl = StringUtils.join((Object[])new String[]{apiUrl, "/userMapping/getAssetLastByIds"});
    }

    @Override
    public String getByUid(String appid, String uid, boolean skipCache) {
        ResponseEntity entity;
        try {
            StringBuilder url = new StringBuilder(this.getByUidUrl);
            url.append("?appId=");
            url.append(appid);
            url.append("&uid=");
            url.append(uid);
            url.append("&skipCache=");
            url.append(skipCache);
            entity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("getByUid error: appid={},uid={},skipCache={},e={}", new Object[]{appid, uid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("getByUid error: appid={},uid={},skipCache={},e={}", new Object[]{appid, uid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (String)entity.getBody();
        }
        log.error("getByUid fail: httpStatus={},appid={},uid={},skipCache={},body={}", new Object[]{httpStatus.value(), appid, uid, skipCache, entity.getBody()});
        throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
    }

    @Override
    public Map<String, String> getByUids(String appid, Collection<String> uids) {
        ResponseEntity entity;
        try {
            StringBuilder url = new StringBuilder(this.getByUidsUrl);
            url.append("?appId=");
            url.append(appid);
            uids.forEach(uid -> {
                url.append("&uids=");
                url.append((String)uid);
            });
            entity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("getByUids error: appid={},uids={},e={}", new Object[]{appid, uids, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("getByUids error: appid={},uids={},e={}", new Object[]{appid, uids, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (Map)JSON.parseObject((String)((String)entity.getBody()), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        log.error("getByUids fail: httpStatus={},appid={},uids={},body={}", new Object[]{httpStatus.value(), appid, uids, entity.getBody()});
        throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
    }

    @Override
    public String getByCuid(String appid, String cuid, boolean skipCache) {
        ResponseEntity entity;
        try {
            StringBuilder url = new StringBuilder(this.getByCuidUrl);
            url.append("?appId=");
            url.append(appid);
            url.append("&cuid=");
            url.append(cuid);
            url.append("&skipCache=");
            url.append(skipCache);
            entity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("getByCuid error: appid={},cuid={},skipCache={},e={}", new Object[]{appid, cuid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("getByCuid error: appid={},cuid={},skipCache={},e={}", new Object[]{appid, cuid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (String)entity.getBody();
        }
        log.error("getByCuid fail: httpStatus={},appid={},cuid={},skipCache={},body={}", new Object[]{httpStatus.value(), appid, cuid, skipCache, entity.getBody()});
        throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
    }

    @Override
    public String getAssetByCuid(String appid, String cuid, boolean skipCache) {
        ResponseEntity entity;
        try {
            StringBuilder url = new StringBuilder(this.getAssetByCuidUrl);
            url.append("?appId=");
            url.append(appid);
            url.append("&cuid=");
            url.append(cuid);
            url.append("&skipCache=");
            url.append(skipCache);
            entity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("getAssetByCuid error: appid={},cuid={},skipCache={},e={}", new Object[]{appid, cuid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("getAssetByCuid error: appid={},cuid={},skipCache={},e={}", new Object[]{appid, cuid, skipCache, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (String)entity.getBody();
        }
        log.error("getAssetByCuid fail: httpStatus={},appid={},cuid={},skipCache={},body={}", new Object[]{httpStatus.value(), appid, cuid, skipCache, entity.getBody()});
        throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
    }

    @Override
    public Map<String, String> getAssetLastByIds(String appid, Collection<String> ids) {
        ResponseEntity entity;
        try {
            StringBuilder url = new StringBuilder(this.getAssetLastByIdsUrl);
            url.append("?appId=");
            url.append(appid);
            ids.forEach(id -> {
                url.append("&ids=");
                url.append((String)id);
            });
            entity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("getAssetLastByIds error: appid={},ids={},e={}", new Object[]{appid, ids, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("getAssetLastByIds error: appid={},ids={},e={}", new Object[]{appid, ids, ExceptionUtils.getFullStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (Map)JSON.parseObject((String)((String)entity.getBody()), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        log.error("getAssetLastByIds fail: httpStatus={},appid={},ids={},body={}", new Object[]{httpStatus.value(), appid, ids, entity.getBody()});
        throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
    }
}

