/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.api.wechat;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class AbstractServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractServiceImpl.class);
    protected final RestTemplate restTemplate;
    protected final String apiUrl;

    public AbstractServiceImpl(RestTemplate restTemplate, String apiUrl) {
        this.restTemplate = restTemplate;
        this.apiUrl = StringUtils.isBlank((CharSequence)apiUrl) ? "http://wechat.bianxianmao.com" : apiUrl;
    }

    protected String getFullUrl(String url) {
        return StringUtils.join((Object[])new String[]{this.apiUrl, url});
    }

    protected <T> T doGet(StringBuilder url, Class<T> clazz) {
        ResponseEntity entity;
        try {
            entity = this.restTemplate.getForEntity(url.toString(), clazz, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("doGet error: url={},e={}", (Object)url, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
        catch (Exception e) {
            log.error("doGet error: url={},e={}", (Object)url, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (T)entity.getBody();
        }
        log.warn("doGet warn: httpStatus={}, url={},body={}", new Object[]{httpStatus.value(), url, entity.getBody()});
        return null;
    }

    protected <T> T doPost(StringBuilder url, Object request, Class<T> clazz) {
        ResponseEntity entity;
        try {
            entity = this.restTemplate.postForEntity(url.toString(), request, clazz, new Object[0]);
        }
        catch (ResourceAccessException e) {
            log.error("doPost error: url={},request={},e={}", new Object[]{url, request, ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        catch (Exception e) {
            log.error("doPost error: url={},request={},e={}", new Object[]{url, request, ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        HttpStatus httpStatus = entity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            return (T)entity.getBody();
        }
        log.warn("doPost warn: httpStatus={},url={},request={},body={}", new Object[]{httpStatus.value(), url, request, entity.getBody()});
        return null;
    }
}

