/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.assets.dao;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.assets.dao.AssetDao;
import com.bxm.game.scene.common.core.user.PermanentAtomicService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RedisAssetDaoImpl
implements AssetDao {
    private final AppConfigFetcher appConfigFetcher;
    private final PermanentAtomicService permanentAtomicService;

    public RedisAssetDaoImpl(AppConfigFetcher appConfigFetcher, PermanentAtomicService permanentAtomicService) {
        this.appConfigFetcher = appConfigFetcher;
        this.permanentAtomicService = permanentAtomicService;
    }

    @Override
    public long plus(String type, long value) {
        return this.permanentAtomicService.hIncrBy("asset", type, value);
    }

    @Override
    public long minus(String type, long value) {
        return this.permanentAtomicService.hIncrBy("asset", type, -value);
    }

    @Override
    public long get(String type) {
        return this.get(type, 0L);
    }

    @Override
    public long get(String type, long defaultValue) {
        return this.permanentAtomicService.hGet("asset", type, defaultValue);
    }

    @Override
    public void set(String type, long value) {
        this.permanentAtomicService.hSet("asset", type, (Object)String.valueOf(value));
    }

    @Override
    public void delete(String type) {
        this.permanentAtomicService.hDel("asset", type);
    }

    @Override
    public Map<String, Object> getAll() {
        HashMap<String, Object> rst = new HashMap<String, Object>();
        Map<String, String> map = this.permanentAtomicService.hGetAll("asset", String.class);
        if (MapUtils.isEmpty(map)) {
            return rst;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NumberUtils.isCreatable((String)value)) {
                rst.put(key, NumberUtils.toInt((String)value));
                continue;
            }
            rst.put(key, value);
        }
        return rst;
    }
}

