/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.autoconfigure;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.assets.dao.AssetDao;
import com.bxm.game.scene.common.core.assets.dao.RedisAssetDaoImpl;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import com.bxm.game.scene.common.core.prop.dao.RedisPropDaoImpl;
import com.bxm.game.scene.common.core.user.PermanentAtomicService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"game.datasource.type"}, havingValue="redis", matchIfMissing=true)
public class RedisAutoConfiguration {
    @Bean
    public static PropDao propDao(AppConfigFetcher appConfigFetcher, @Qualifier(value="jedisFetcher") Fetcher fetcher, @Qualifier(value="jedisUpdater") Updater updater) {
        return new RedisPropDaoImpl(appConfigFetcher, fetcher, updater);
    }

    @Bean
    public static AssetDao assetDao(AppConfigFetcher appConfigFetcher, PermanentAtomicService permanentAtomicService) {
        return new RedisAssetDaoImpl(appConfigFetcher, permanentAtomicService);
    }
}

