/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.autoconfigure.activity;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.autoconfigure.activity.ActivityService;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final String DEFAULT_CODE = "default";

    public ActivityServiceImpl(AppConfigFetcher appConfigFetcher, @Qualifier(value="jedisFetcher") Fetcher fetcher) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
    }

    @Override
    public <T> T getConfig(Class<T> clazz) {
        return this.getConfig(AppContext.get().getAppId(), clazz);
    }

    @Override
    public <T> T getConfig(String appid, Class<T> clazz) {
        T config = this.getConfig0(appid, clazz);
        if (Objects.isNull(config) && Objects.isNull(config = this.getConfig0("default", clazz))) {
            throw new GameException(DefaultErrGen.CONFIG_INVALID);
        }
        return config;
    }

    private <T> T getConfig0(String appid, Class<T> clazz) {
        return (T)this.fetcher.hfetch(this.hash(), appid, clazz);
    }

    private KeyGenerator hash() {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "config"});
    }
}

