/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.autoconfigure.app;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.autoconfigure.activity.ActivityConfig;
import com.bxm.game.scene.common.core.autoconfigure.activity.ActivityService;
import com.bxm.game.scene.common.core.autoconfigure.app.BaseAppConfigService;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAppConfigServiceImpl<T>
implements BaseAppConfigService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseAppConfigServiceImpl.class);
    @Autowired(required=false)
    protected ActivityService activityService;
    private final LoadingCache<String, Optional<T>> configCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build(new CacheLoader<String, Optional<T>>(){

        public Optional<T> load(String key) {
            return Optional.empty();
        }
    });

    protected <T> T getAppConfig(Class<T> clazz) {
        String appid = AppContext.get().getAppId();
        return this.getAppConfig(appid, clazz);
    }

    protected <T> T getAppConfig(String gcode, String appid, Class<T> clazz) {
        return this.getAppConfig(CommonHelper.getConfigField(gcode, appid), clazz);
    }

    protected <T> T getAppConfig(String appid, Class<T> clazz) {
        ActivityConfig activityConfig = this.getActivityConfig(appid);
        if (null == activityConfig) {
            log.error("Not find config, appid={}", (Object)appid);
            throw new GameException(DefaultErrGen.CONFIG_INVALID);
        }
        return (T)JsonHelper.convert((String)activityConfig.getConfig(), clazz);
    }

    protected ActivityConfig getActivityConfig(String appid) {
        try {
            return this.activityService.getConfig(appid, ActivityConfig.class);
        }
        catch (Exception e) {
            log.error("getActivityConfig error: appid={},e={}", (Object)appid, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public T getConfig(String gcode, String appid) {
        T t = this.getConfig0(gcode, appid);
        if (Objects.isNull(t)) {
            log.error("Not find config, gcode={},appid={}", (Object)gcode, (Object)appid);
            throw new GameException(DefaultErrGen.CONFIG_INVALID);
        }
        return t;
    }

    private T getConfig0(String gcode, String appid) {
        try {
            String cacheKey = KeyBuilder.build((Object[])new Object[]{gcode, appid});
            Optional appConfig = (Optional)this.configCache.get((Object)cacheKey, () -> {
                Object t = this.getRealConfig(gcode, appid);
                return Optional.ofNullable(t);
            });
            return appConfig.orElse(null);
        }
        catch (Exception e) {
            log.error("getConfig0 error: gcode={},appid={},e={}", new Object[]{gcode, appid, ExceptionUtils.getStackTrace((Throwable)e)});
            return null;
        }
    }

    @Override
    public Integer getNum(Integer fixed, Integer min, Integer max, Integer defaultVal) {
        if (null != fixed) {
            return Optional.ofNullable(fixed).orElse(defaultVal);
        }
        if (null != min && null != max) {
            if (max < min) {
                log.error("getNum error: 'max'<'min', gcode={},appid={},fixed={},min={},max={},defaultVal={}", new Object[]{AppContext.get().getGameCode(), AppContext.get().getAppId(), fixed, min, max, defaultVal});
                return defaultVal;
            }
            return RandomUtils.nextInt((int)min, (int)(max + 1));
        }
        return defaultVal;
    }
}

