/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.autoconfigure.app;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.autoconfigure.activity.ActivityConfig;
import com.bxm.game.scene.common.core.autoconfigure.activity.ActivityService;
import com.bxm.game.scene.common.core.autoconfigure.app.RedisAppConfigService;
import com.bxm.game.scene.common.core.autoconfigure.app.RedisSceneCommonConfig;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RedisAppConfigServiceImpl<A, S extends RedisSceneCommonConfig>
implements RedisAppConfigService<A, S> {
    private static final Logger log = LoggerFactory.getLogger(RedisAppConfigServiceImpl.class);
    @Autowired
    protected ActivityService activityService;
    private static final LoadingCache<String, Optional<ActivityConfig>> ACTIVITY_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<ActivityConfig>>(){

        public Optional<ActivityConfig> load(String key) throws Exception {
            return Optional.empty();
        }
    });

    protected <T> T getAppConfig(Class<T> clazz) {
        String appid = AppContext.get().getAppId();
        return this.getAppConfig(appid, clazz);
    }

    protected <T> T getAppConfig(String gcode, String appid, Class<T> clazz) {
        return this.getAppConfig(CommonHelper.getConfigField(gcode, appid), clazz);
    }

    protected <T> T getAppConfig(String appid, Class<T> clazz) {
        ActivityConfig activityConfig = this.getActivityConfig(appid);
        if (null == activityConfig) {
            log.error("Not find config, appid={}", (Object)appid);
            throw new GameException(DefaultErrGen.CONFIG_INVALID);
        }
        return (T)JsonHelper.convert((String)activityConfig.getConfig(), clazz);
    }

    protected ActivityConfig getActivityConfig(String appid) {
        try {
            Optional appConfig = (Optional)ACTIVITY_CACHE.get((Object)appid, () -> {
                ActivityConfig record = this.activityService.getConfig(appid, ActivityConfig.class);
                return Optional.ofNullable(record);
            });
            return appConfig.orElse(null);
        }
        catch (Exception e) {
            log.error("getActivityConfig error: appid={},e={}", (Object)appid, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public Integer getFrequency(String scene) {
        return this.getFrequency((RedisSceneCommonConfig)this.getSceneConfig(scene));
    }

    @Override
    public Integer getFrequency(String scene, int period) {
        return this.getFrequency((RedisSceneCommonConfig)this.getSceneConfig(scene, period));
    }

    @Override
    public Integer getFrequency(RedisSceneCommonConfig config) {
        if (null == config) {
            return 0;
        }
        if (null != config.getFreqFixed()) {
            return this.defaultVal(config.getFreqFixed(), 0);
        }
        if (null != config.getFreqMin() && null != config.getFreqMax()) {
            if (config.getFreqMax() < config.getFreqMin()) {
                log.error("getFrequency error: 'freqMax'<'freqMin', gcode={},appid={},fixed={},min={},max={}", new Object[]{AppContext.get().getGameCode(), AppContext.get().getAppId(), config.getFreqFixed(), config.getFreqMin(), config.getFreqMax()});
                return 0;
            }
            return RandomUtils.nextInt((int)config.getFreqMin(), (int)(config.getFreqMax() + 1));
        }
        return 0;
    }

    @Override
    public Integer getAssetNum(String scene) {
        return this.getAssetNum((RedisSceneCommonConfig)this.getSceneConfig(scene));
    }

    @Override
    public Integer getAssetNum(String scene, int period) {
        return this.getAssetNum((RedisSceneCommonConfig)this.getSceneConfig(scene, period));
    }

    @Override
    public Integer getAssetNum(RedisSceneCommonConfig config) {
        if (null == config) {
            return 0;
        }
        if (null != config.getFixed()) {
            return this.defaultVal(config.getFixed(), 0);
        }
        if (null != config.getMin() && null != config.getMax()) {
            if (config.getMax() < config.getMin()) {
                log.error("getAssetNum error: 'freqMax'<'freqMin', gcode={},appid={},fixed={},min={},max={}", new Object[]{AppContext.get().getGameCode(), AppContext.get().getAppId(), config.getFixed(), config.getMin(), config.getMax()});
                return 0;
            }
            return RandomUtils.nextInt((int)config.getMin(), (int)(config.getMax() + 1));
        }
        return 0;
    }

    @Override
    public Integer getAssetNum(String scene, String sequence) {
        return this.getAssetNum((RedisSceneCommonConfig)this.getSceneConfig(scene), sequence);
    }

    @Override
    public Integer getAssetNum(String scene, int period, String sequence) {
        return this.getAssetNum((RedisSceneCommonConfig)this.getSceneConfig(scene, period), sequence);
    }

    @Override
    public Integer getAssetNum(RedisSceneCommonConfig config, String sequence) {
        if (null == config || null == config.getAssetsMap()) {
            return 0;
        }
        Map<String, Integer> map = config.getAssetsMap();
        return this.defaultVal(map.get(sequence), 0);
    }

    @Override
    public Number getMultipleNum(String scene) {
        return this.getMultipleNum((RedisSceneCommonConfig)this.getSceneConfig(scene));
    }

    @Override
    public Number getMultipleNum(String scene, int period) {
        return this.getMultipleNum((RedisSceneCommonConfig)this.getSceneConfig(scene, period));
    }

    @Override
    public Number getMultipleNum(RedisSceneCommonConfig config) {
        if (null == config) {
            return 1;
        }
        return this.defaultVal(config.getMultiple(), (Number)1);
    }

    @Override
    public Integer getLimitNum(String scene) {
        return this.getLimitNum((RedisSceneCommonConfig)this.getSceneConfig(scene));
    }

    @Override
    public Integer getLimitNum(String scene, int period) {
        return this.getLimitNum((RedisSceneCommonConfig)this.getSceneConfig(scene, period));
    }

    @Override
    public Integer getLimitNum(RedisSceneCommonConfig config) {
        if (null == config) {
            return 0;
        }
        return this.defaultVal(config.getLimit(), 0);
    }

    @Override
    public Integer getLimitNum(String scene, String sequence) {
        return this.getLimitNum((RedisSceneCommonConfig)this.getSceneConfig(scene), sequence);
    }

    @Override
    public Integer getLimitNum(String scene, int period, String sequence) {
        return this.getLimitNum((RedisSceneCommonConfig)this.getSceneConfig(scene, period), sequence);
    }

    @Override
    public Integer getLimitNum(RedisSceneCommonConfig config, String sequence) {
        if (null == config || null == config.getLimitMap()) {
            return 0;
        }
        Map<String, Integer> map = config.getLimitMap();
        return this.defaultVal(map.get(sequence), 0);
    }

    protected Integer defaultVal(Integer num, Integer defNum) {
        return null == num ? defNum : num;
    }

    protected Number defaultVal(Number num, Number defNum) {
        return null == num ? (Number)defNum : (Number)num;
    }
}

