/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.action;

import com.bxm.game.scene.common.core.fun.action.SceneActionFetcher;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class SceneActionServiceFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SceneActionServiceFactory.class);
    private final Map<String, SceneActionFetcher> map = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansOfType(SceneActionFetcher.class);
        for (SceneActionFetcher service : beans.values()) {
            this.map.put(service.getSceneType(), service);
            log.info("Registering SceneActionFetcher to Factory: {}", (Object)service);
        }
    }

    public SceneActionFetcher get(String sceneType) {
        return this.map.get(sceneType);
    }
}

