/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.archives;

import com.bxm.game.scene.common.core.fun.archives.CustomArchiveDataService;
import com.bxm.game.scene.common.core.fun.archives.CustomArchiveHandler;
import com.bxm.game.scene.common.core.fun.archives.CustomArchiveHandlerFactory;
import com.bxm.game.scene.common.core.fun.archives.SceneCustomArchiveHandler;
import com.bxm.game.scene.common.core.fun.archives.annotation.DeleteOnCompleted;
import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class CustomArchiveDeleteOnCompletedListener
implements EventListener<AcquiredPropEvent> {
    private static final Logger log = LoggerFactory.getLogger(CustomArchiveDeleteOnCompletedListener.class);
    private final CustomArchiveHandlerFactory customArchiveHandlerFactory;
    private final CustomArchiveDataService customArchiveDataService;

    public CustomArchiveDeleteOnCompletedListener(CustomArchiveHandlerFactory customArchiveHandlerFactory, CustomArchiveDataService customArchiveDataService) {
        this.customArchiveHandlerFactory = customArchiveHandlerFactory;
        this.customArchiveDataService = customArchiveDataService;
    }

    @Subscribe
    public void consume(AcquiredPropEvent event) {
        ImmutableSet<CustomArchiveHandler> handlers = this.customArchiveHandlerFactory.getHandlers();
        for (CustomArchiveHandler handler : handlers) {
            Object[] sceneTypes;
            SceneCustomArchiveHandler sceneCustomArchiveHandler;
            DeleteOnCompleted delete;
            if (!(handler instanceof SceneCustomArchiveHandler) || Objects.isNull(delete = ClassUtils.getUserClass((sceneCustomArchiveHandler = (SceneCustomArchiveHandler)handler).getClass()).getAnnotation(DeleteOnCompleted.class)) || !ArrayUtils.contains((Object[])(sceneTypes = delete.sceneTypes()), (Object)event.getSceneType())) continue;
            try {
                String key = sceneCustomArchiveHandler.getKey().generateKey();
                String field = event.getSceneRequest().getId();
                this.customArchiveDataService.hdel(key, field);
            }
            catch (Exception e) {
                log.warn("ignore exception: ", (Throwable)e);
            }
        }
    }
}

