/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.archives;

import com.bxm.game.scene.common.core.fun.archives.CustomArchiveHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class CustomArchiveHandlerFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(CustomArchiveHandlerFactory.class);
    private final Set<CustomArchiveHandler> handlers = Sets.newHashSet();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map beans = event.getApplicationContext().getBeansOfType(CustomArchiveHandler.class);
        for (CustomArchiveHandler bean : beans.values()) {
            this.handlers.add(bean);
            log.info("Registering CustomArchiveHandler to Factory: {}", (Object)bean);
        }
    }

    public ImmutableSet<CustomArchiveHandler> getHandlers() {
        return ImmutableSet.copyOf(this.handlers);
    }
}

