/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.config;

import com.bxm.game.scene.common.core.fun.config.SceneConfigFetcher;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class SceneConfigServiceFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SceneConfigServiceFactory.class);
    private final Map<String, SceneConfigFetcher> map = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansOfType(SceneConfigFetcher.class);
        for (SceneConfigFetcher service : beans.values()) {
            this.map.put(service.getSceneType(), service);
            log.info("Registering SceneActionFetcher to Factory: {}", (Object)service);
        }
    }

    public SceneConfigFetcher get(String sceneType) {
        return this.map.get(sceneType);
    }
}

