/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.api.user.BxmUserMappingService;
import com.bxm.game.scene.common.core.fun.job.AppUidInfo;
import com.bxm.game.scene.common.core.fun.job.JobRequest;
import com.bxm.game.scene.common.core.fun.job.SynAssetModel;
import com.bxm.game.scene.common.core.fun.job.UserDailyJobDao;
import com.bxm.game.scene.common.core.fun.job.UserDailyKey;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.game.scene.common.dal.entity.AssetsSnapshot;
import com.bxm.game.scene.common.dal.service.IAssetsSnapshotService;
import com.bxm.warcar.cache.Fetcher;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@ConditionalOnMissingBean(value={UserDailyJobDao.class})
public class EmptyUserDailyJobDaoImpl
implements UserDailyJobDao {
    private static final Logger log = LoggerFactory.getLogger(EmptyUserDailyJobDaoImpl.class);
    private final int REDIS_BACH_UID_MIN = 100000;
    private final int SQL_BATH_LIMIT = 5000;
    private final int API_BATH_LIMIT = 100;
    @Autowired
    @Qualifier(value="jedisFetcher")
    protected Fetcher fetcher;
    @Autowired
    protected AppConfigFetcher appConfigFetcher;
    @Autowired
    protected IAssetsSnapshotService iAssetsSnapshotService;
    @Autowired(required=false)
    protected BxmUserMappingService bxmUserMappingService;
    @Autowired(required=false)
    protected UserDailyKey userDailyKey;

    @Override
    public void beforeSynUserDaily(JobRequest request, String rptDate) {
        this.delAssetDaily(rptDate);
    }

    protected void delAssetDaily(String rptDate) {
        QueryWrapper query = Wrappers.query((Object)new AssetsSnapshot().setRptDate(rptDate).setActivityType(this.appConfigFetcher.activityType()));
        this.iAssetsSnapshotService.remove((Wrapper)query);
    }

    @Override
    public void doBucketSynUserDaily(JobRequest request, String rptDate, String gcode, String appid, List<AppUidInfo> appUidInfos) {
        this.synAssetDaily(rptDate, gcode, appid, appUidInfos);
    }

    protected void synAssetDaily(String rptDate, String gcode, String appid, List<AppUidInfo> appUidInfos) {
        List<String> assetTypes = this.appConfigFetcher.synAssetTypes();
        if (CollectionUtils.isEmpty(assetTypes)) {
            return;
        }
        List<SynAssetModel> synAssetModels = this.appConfigFetcher.synAssetModels();
        if (synAssetModels.contains((Object)SynAssetModel.PERMANENT)) {
            this.insertAssetData(rptDate, gcode, appid, appUidInfos, assetTypes);
        }
        if (synAssetModels.contains((Object)SynAssetModel.BOUND)) {
            this.insertBoundAssetData(rptDate, gcode, appid, appUidInfos, assetTypes);
        }
    }

    protected void insertAssetData(String rptDate, String gcode, String appid, List<AppUidInfo> appUidInfos, List<String> assetTypes) {
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        HashMap<String, Response<Map<String, String>>> assetRsMap = new HashMap<String, Response<Map<String, String>>>();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipeline = jedis.pipelined();
            for (AppUidInfo appUidInfo : appUidInfos) {
                String key = this.getAssetRedisKey(gcode, appid, appUidInfo);
                assetRsMap.put(appUidInfo.getUid(), (Response<Map<String, String>>)pipeline.hgetAll(key));
            }
            pipeline.syncAndReturnAll();
        }
        this.assembleAssetDaily(rptDate, gcode, appid, appUidInfos, assetTypes, assetRsMap);
    }

    protected void insertBoundAssetData(String rptDate, String gcode, String appid, List<AppUidInfo> appUidInfos, List<String> assetTypes) {
        String key;
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        HashMap<String, Response> anchorRsMap = new HashMap<String, Response>();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipeline = jedis.pipelined();
            for (AppUidInfo appUidInfo : appUidInfos) {
                key = this.userDailyKey.getBoundAnchor(gcode, appid, appUidInfo.getUid());
                anchorRsMap.put(appUidInfo.getUid(), pipeline.get(key));
            }
            pipeline.syncAndReturnAll();
        }
        HashMap<String, Response<Map<String, String>>> assetRsMap = new HashMap<String, Response<Map<String, String>>>();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipeline = jedis.pipelined();
            for (AppUidInfo appUidInfo : appUidInfos) {
                String anchor = (String)((Response)anchorRsMap.get(appUidInfo.getUid())).get();
                if (null == anchor) continue;
                key = this.getBoundAssetRedisKey(gcode, appid, appUidInfo, anchor);
                assetRsMap.put(appUidInfo.getUid(), (Response<Map<String, String>>)pipeline.hgetAll(key));
            }
            pipeline.syncAndReturnAll();
        }
        this.assembleAssetDaily(rptDate, gcode, appid, appUidInfos, assetTypes, assetRsMap);
    }

    protected void assembleAssetDaily(String rptDate, String gcode, String appid, List<AppUidInfo> appUidInfos, List<String> assetTypes, Map<String, Response<Map<String, String>>> assetRsMap) {
        int sqlBathLimit = this.getSqlBathLimit();
        boolean isSynSnapshotForNoAssetsUser = this.isSynSnapshotForNoAssetsUser(appid);
        LocalDateTime currentDate = LocalDateTime.now();
        ArrayList<AssetsSnapshot> snapshots = new ArrayList<AssetsSnapshot>();
        for (AppUidInfo appUidInfo : appUidInfos) {
            HashMap assetMap = (HashMap)assetRsMap.get(appUidInfo.getUid()).get();
            if (null == assetMap) {
                if (!isSynSnapshotForNoAssetsUser) continue;
                assetMap = new HashMap();
            }
            for (String assetType : assetTypes) {
                AssetsSnapshot snapshot = new AssetsSnapshot();
                snapshots.add(snapshot);
                Integer assetNum = Integer.valueOf(assetMap.getOrDefault(assetType, "0"));
                snapshot.setRptDate(rptDate);
                snapshot.setGameCode(gcode);
                snapshot.setAppId(appid);
                snapshot.setUid(appUidInfo.getUid());
                snapshot.setAppUid(Optional.ofNullable(appUidInfo.getCuid()).orElse(""));
                snapshot.setActivityType(this.appConfigFetcher.activityType());
                snapshot.setAssetType(assetType);
                snapshot.setAssetNum(assetNum);
                snapshot.setCreateTime(currentDate);
                if (snapshots.size() != sqlBathLimit) continue;
                this.iAssetsSnapshotService.saveBatch(snapshots);
                snapshots = new ArrayList();
                currentDate = LocalDateTime.now();
            }
        }
        if (snapshots.size() > 0) {
            this.iAssetsSnapshotService.saveBatch(snapshots);
        }
    }

    @Override
    public List<AppUidInfo> getBucketAppUidInfos(String appid, Set<String> uids) {
        List<AppUidInfo> appUidInfos = this.getAppUidInfos(appid, uids);
        if (this.hasHandleAppUidInfo(appid)) {
            this.handleBucketAppUidInfos(appid, appUidInfos);
        }
        return appUidInfos;
    }

    protected boolean hasHandleAppUidInfo(String appid) {
        return false;
    }

    protected List<AppUidInfo> getAppUidInfos(String appid, Set<String> uids) {
        ArrayList<AppUidInfo> appUidInfos = new ArrayList<AppUidInfo>();
        for (String uid : uids) {
            appUidInfos.add(new AppUidInfo().setUid(uid));
        }
        return appUidInfos;
    }

    protected void handleBucketAppUidInfos(String appid, List<AppUidInfo> appUidInfos) {
        int apiBathLimit = this.getApiBathLimit();
        ArrayList<AppUidInfo> list = new ArrayList<AppUidInfo>();
        for (AppUidInfo appUidInfo : appUidInfos) {
            list.add(appUidInfo);
            if (list.size() != apiBathLimit) continue;
            this.subHandleAppUidInfo(appid, list);
            list = new ArrayList();
        }
        if (list.size() > 0) {
            this.subHandleAppUidInfo(appid, list);
        }
    }

    protected void subHandleAppUidInfo(String appid, List<AppUidInfo> list) {
        this.handleAppUidInfoForUid(appid, list);
    }

    protected void handleAppUidInfoForUid(String appid, List<AppUidInfo> list) {
        List<String> uids = list.stream().map(o -> o.getUid()).collect(Collectors.toList());
        Map<String, String> cuidMap = this.bxmUserMappingService.getByUids(appid, uids);
        if (MapUtils.isEmpty(cuidMap)) {
            return;
        }
        for (AppUidInfo appUidInfo : list) {
            String cuid = cuidMap.get(appUidInfo.getUid());
            appUidInfo.setCuid(Optional.ofNullable(cuid).orElse(""));
        }
    }

    protected void handleAppUidInfoForAsset(String appid, List<AppUidInfo> list) {
        List<String> uids = list.stream().map(o -> o.getUid()).collect(Collectors.toList());
        Map<String, String> cuidMap = this.bxmUserMappingService.getAssetLastByIds(appid, uids);
        if (MapUtils.isEmpty(cuidMap)) {
            return;
        }
        for (AppUidInfo appUidInfo : list) {
            String cuid = cuidMap.get(appUidInfo.getUid());
            appUidInfo.setCuid(Optional.ofNullable(cuid).orElse(""));
        }
    }

    @Override
    public int getRedisBachUidMin() {
        return 100000;
    }

    protected int getSqlBathLimit() {
        return 5000;
    }

    protected int getApiBathLimit() {
        return 100;
    }

    protected boolean isSynSnapshotForNoAssetsUser(String appid) {
        return false;
    }

    @Override
    public String getAssetRedisKey(String gcode, String appid, AppUidInfo appUidInfo) {
        return this.userDailyKey.getPermanentAsset(gcode, appid, appUidInfo.getUid());
    }

    @Override
    public String getBoundAssetRedisKey(String gcode, String appid, AppUidInfo appUidInfo, String anchor) {
        return this.userDailyKey.getBoundAsset(anchor, gcode, appid, appUidInfo.getUid());
    }
}

