/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.job;

import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.fun.job.AppUidInfo;
import com.bxm.game.scene.common.core.fun.job.JobRequest;
import com.bxm.game.scene.common.core.fun.job.UserDailyJobDao;
import com.bxm.game.scene.common.core.fun.job.UserDailyJobService;
import com.bxm.game.scene.common.core.fun.job.UserDailyKey;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.RedisLock;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class UserDailyJobServiceImpl
implements UserDailyJobService {
    private static final Logger log = LoggerFactory.getLogger(UserDailyJobServiceImpl.class);
    private final String JOB_SYN_USER_DAILY = "synUserDaily";
    private final int JOB_LOCK_TIMES = 600000;
    private final Fetcher fetcher;
    private final UserDailyJobDao userDailyDao;
    private final Key key;
    private final UserDailyKey userDailyKey;
    private final RedisLock redisLock;

    public UserDailyJobServiceImpl(@Qualifier(value="jedisFetcher") Fetcher fetcher, UserDailyJobDao userDailyDao, Key key, UserDailyKey userDailyKey, @Qualifier(value="distributedRedisLock") RedisLock redisLock) {
        this.fetcher = fetcher;
        this.userDailyDao = userDailyDao;
        this.key = key;
        this.userDailyKey = userDailyKey;
        this.redisLock = redisLock;
    }

    @Override
    public void synUserDaily(JobRequest request) {
        int expireTime = Optional.ofNullable(request.getLockTimes()).orElse(600000);
        String lockKey = this.key.getJobLock("synUserDaily").generateKey();
        boolean isLock = this.redisLock.tryLock(lockKey, "synUserDaily", expireTime);
        if (!isLock) {
            throw new RuntimeException("\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c");
        }
        new Thread(() -> {
            try {
                Date startDate = new Date();
                log.info("synUserDaily start: startTime={}", (Object)DateHelper.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss"));
                String rptDate = DateHelper.format((Date)startDate, (String)"yyyyMMdd");
                ThreadPoolExecutor threadPool = this.userDailyDao.getThreadPool();
                this.userDailyDao.beforeSynUserDaily(request, rptDate);
                this.synUserDaily0(request, rptDate, threadPool);
                do {
                    Thread.sleep(3000L);
                } while (threadPool.getActiveCount() >= 1);
                this.userDailyDao.afterSynUserDaily(request, rptDate);
                Date endDate = new Date();
                log.info("synUserDaily end\uff1aendTime={},elapsed time {} ms", (Object)DateHelper.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"), (Object)(endDate.getTime() - startDate.getTime()));
            }
            catch (Exception e) {
                log.error("synUserDaily error:", (Throwable)e);
            }
            finally {
                this.redisLock.unLock(lockKey, "synUserDaily");
            }
        }).start();
    }

    private void synUserDaily0(JobRequest request, String rptDate, ThreadPoolExecutor threadPool) {
        int redisBachUidMin = this.userDailyDao.getRedisBachUidMin();
        Set<String> gcodes = this.getGcodes();
        if (CollectionUtils.isEmpty(gcodes)) {
            log.warn("synUserDaily0 'gcodes' is empty");
            return;
        }
        Set<String> appids = this.getAppIds();
        if (CollectionUtils.isEmpty(appids)) {
            log.warn("synUserDaily0 'appids' is empty");
            return;
        }
        for (String gcode : gcodes) {
            for (String appid : appids) {
                if (!this.userDailyDao.hasApp(appid)) continue;
                double[] scores = this.userDailyDao.getConditionForUserScore(appid);
                threadPool.execute(() -> {
                    int sections;
                    long zcards;
                    ArrayList<String> keys = new ArrayList<String>();
                    for (int bucket = 0; bucket < 1000; ++bucket) {
                        keys.add(this.userDailyKey.getRegisterUsers(appid, bucket));
                    }
                    JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
                    try (Jedis jedis = jedisPool.getResource();){
                        zcards = jedis.zcard((String)keys.get(0));
                    }
                    int bachSize = zcards < 1L ? keys.size() : ((sections = (int)((long)redisBachUidMin / zcards)) < 1 ? 1 : sections);
                    List bachList = Lists.partition(keys, (int)bachSize);
                    this.doBachMember(request, rptDate, gcode, appid, bachList, scores);
                });
            }
        }
    }

    private void doBachMember(JobRequest request, String rptDate, String gcode, String appid, List<List<String>> bachList, double[] scores) {
        boolean unLimit = null == scores || scores.length < 2;
        ArrayList uidsList = new ArrayList();
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        Throwable throwable = null;
        try (Jedis jedis = jedisPool.getResource();){
            for (List<String> subKeys : bachList) {
                ArrayList<Response> memberRsList = new ArrayList<Response>();
                Pipeline pipeline = jedis.pipelined();
                for (String subKey : subKeys) {
                    if (unLimit) {
                        memberRsList.add(pipeline.zrange(subKey, 0L, -1L));
                        continue;
                    }
                    memberRsList.add(pipeline.zrangeByScore(subKey, scores[0], scores[1]));
                }
                pipeline.syncAndReturnAll();
                HashSet uids = new HashSet();
                for (Response memberRs : memberRsList) {
                    Set set = (Set)memberRs.get();
                    if (null == set) continue;
                    uids.addAll(set);
                }
                if (uids.size() <= 0) continue;
                uidsList.add(uids);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Set set : uidsList) {
            this.doBachMember0(request, rptDate, gcode, set, appid);
        }
    }

    private void doBachMember0(JobRequest request, String rptDate, String gcode, Set<String> uids, String appid) {
        List<AppUidInfo> appUidInfos = this.userDailyDao.getBucketAppUidInfos(appid, uids);
        this.userDailyDao.doBucketSynUserDaily(request, rptDate, gcode, appid, appUidInfos);
    }

    private Set<String> getGcodes() {
        HashSet<String> gcodes = new HashSet<String>();
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        double[] scores = this.userDailyDao.getConditionForGameScore();
        boolean unLimit = null == scores || scores.length < 2;
        try (Jedis jedis = jedisPool.getResource();){
            for (int bucket = 0; bucket < 10; ++bucket) {
                String key = this.userDailyKey.getRegisterGames(bucket);
                Set members = unLimit ? jedis.zrange(key, 0L, -1L) : jedis.zrangeByScore(key, scores[0], scores[1]);
                if (null == members) continue;
                gcodes.addAll(members);
            }
        }
        return gcodes;
    }

    private Set<String> getAppIds() {
        HashSet<String> appids = new HashSet<String>();
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        double[] scores = this.userDailyDao.getConditionForAppScore();
        boolean unLimit = null == scores || scores.length < 2;
        try (Jedis jedis = jedisPool.getResource();){
            for (int bucket = 0; bucket < 10; ++bucket) {
                String key = this.userDailyKey.getRegisterApps(bucket);
                Set members = unLimit ? jedis.zrange(key, 0L, -1L) : jedis.zrangeByScore(key, scores[0], scores[1]);
                if (null == members) continue;
                appids.addAll(members);
            }
        }
        return appids;
    }
}

