/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.fun.wxmini.dao;

import com.bxm.game.scene.common.core.api.wechat.BxmWxMessageService;
import com.bxm.game.scene.common.core.api.wechat.body.BxmWxCustomerMessageForwardBody;
import com.bxm.game.scene.common.core.api.wechat.model.BxmWxCustomerMessageDecryptRequest;
import com.bxm.game.scene.common.core.api.wechat.model.BxmWxCustomerMessageRequest;
import com.bxm.game.scene.common.core.fun.wxmini.WxMiniCustomerMessagePlaintextInfo;
import com.bxm.game.scene.common.core.fun.wxmini.WxMiniCustomerMessageRequest;
import com.bxm.game.scene.common.core.fun.wxmini.dao.WxMiniCustomerMessageDao;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EmptyWxMiniCustomerMessageDao
implements WxMiniCustomerMessageDao {
    private static final Logger log = LoggerFactory.getLogger(EmptyWxMiniCustomerMessageDao.class);
    @Autowired
    protected BxmWxMessageService bxmWxMessageService;

    @Override
    public WxMiniCustomerMessagePlaintextInfo decrypt(WxMiniCustomerMessageRequest request) {
        BxmWxCustomerMessageDecryptRequest decryptRequest = this.getBxmWxCustomerMessageDecryptRequest(request);
        if (null == decryptRequest) {
            return null;
        }
        String plaintext = this.bxmWxMessageService.decryptCustomerMessage(decryptRequest);
        return (WxMiniCustomerMessagePlaintextInfo)JsonHelper.convert((String)plaintext, WxMiniCustomerMessagePlaintextInfo.class);
    }

    protected abstract BxmWxCustomerMessageDecryptRequest getBxmWxCustomerMessageDecryptRequest(WxMiniCustomerMessageRequest var1);

    protected void forwardMessage(String appId, String appSecret, WxMiniCustomerMessagePlaintextInfo plaintextInfo) {
        BxmWxCustomerMessageForwardBody forwardBody = new BxmWxCustomerMessageForwardBody();
        forwardBody.setTouser(plaintextInfo.getToUserName());
        forwardBody.setFromuser(plaintextInfo.getFromUserName());
        forwardBody.setCreateTime(plaintextInfo.getCreateTime().toString());
        BxmWxCustomerMessageRequest request = new BxmWxCustomerMessageRequest();
        request.setAppId(appId);
        request.setAppSecret(appSecret);
        request.setMode(2);
        request.setForwardBody(forwardBody);
        this.bxmWxMessageService.sendCustomerMessage(request);
    }
}

