/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.prop.dao;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import com.bxm.game.scene.common.dal.service.IAcquiredPropLogService;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

@ConditionalOnProperty(name={"game.datasource.type"}, havingValue="db")
public class DbPropDaoImpl
implements PropDao,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DbPropDaoImpl.class);
    private final AppConfigFetcher appConfigFetcher;
    private final IAcquiredPropLogService acquiredPropLogService;

    public DbPropDaoImpl(AppConfigFetcher appConfigFetcher, IAcquiredPropLogService acquiredPropLogService) {
        this.appConfigFetcher = appConfigFetcher;
        this.acquiredPropLogService = acquiredPropLogService;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        log.info("'create table scheduler' move to the 'game-center'.");
    }

    @Override
    public boolean saveTakeLog(AcquiredPropLog log) {
        com.bxm.game.scene.common.dal.entity.AcquiredPropLog e = new com.bxm.game.scene.common.dal.entity.AcquiredPropLog();
        e.setId(log.getId()).setAppId(log.getAppId()).setUid(log.getUid()).setAssetType(log.getAssetType()).setSceneType(log.getSceneType()).setPropNum(Integer.valueOf(log.getPropNum())).setMultipleNum(log.getMultipleNum()).setCompletedMultiple(log.isCompletedMultiple()).setAcquired(log.isAcquired()).setStartAcquireTime(Long.valueOf(log.getStartAcquireTime())).setEndAcquireTime(Long.valueOf(log.getEndAcquireTime()));
        return this.acquiredPropLogService.saveOrUpdate((Object)e);
    }

    @Override
    public AcquiredPropLog getTakeLog(String id) {
        com.bxm.game.scene.common.dal.entity.AcquiredPropLog log = (com.bxm.game.scene.common.dal.entity.AcquiredPropLog)this.acquiredPropLogService.getById((Serializable)((Object)id));
        if (Objects.isNull(log)) {
            return null;
        }
        return AcquiredPropLog.of(log);
    }
}

