/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.prop.dao;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Objects;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(name={"game.datasource.type"}, havingValue="redis", matchIfMissing=true)
public class RedisPropDaoImpl
implements PropDao {
    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final Updater updater;

    public RedisPropDaoImpl(AppConfigFetcher appConfigFetcher, Fetcher fetcher, Updater updater) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public boolean saveTakeLog(AcquiredPropLog log) {
        if (Objects.isNull(log) || Objects.isNull(log.getId())) {
            return true;
        }
        this.updater.update(this.hash(log.getId()), (Object)log, this.appConfigFetcher.ttlTakeLog());
        return true;
    }

    @Override
    public AcquiredPropLog getTakeLog(String id) {
        AcquiredPropLog propLog = (AcquiredPropLog)this.fetcher.fetch(this.hash(id), AcquiredPropLog.class);
        return Optional.ofNullable(propLog).orElse(null);
    }

    private KeyGenerator hash(String id) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfigFetcher.namespace(), "take_log", id});
    }
}

