/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.prop.impl;

import com.bxm.game.scene.common.core.assets.AssetService;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropGrantor;
import com.bxm.game.scene.common.core.prop.event.PropGrantEvent;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.utils.JsonHelper;
import java.util.EventObject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

@ConditionalOnMissingBean(value={PropGrantor.class})
public class DefaultPropGrantorImpl
implements PropGrantor {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropGrantorImpl.class);
    private final AssetService assetService;
    private final SyncEventPark syncEventPark;

    public DefaultPropGrantorImpl(AssetService assetService, SyncEventPark syncEventPark) {
        this.assetService = assetService;
        this.syncEventPark = syncEventPark;
    }

    @Override
    public boolean grant(Prop prop, boolean isMultiple) {
        if (!prop.acquired()) {
            return false;
        }
        if (isMultiple && prop.multipleNum().doubleValue() > 0.0) {
            return this.multiple(prop);
        }
        return this.single(prop);
    }

    @Override
    public boolean single(Prop prop) {
        long after;
        try {
            after = this.assetService.plus(prop.getAssetType(), prop.propNum(), prop.getAct());
        }
        catch (Exception e) {
            log.error("single error: prop={}, e={}", (Object)JsonHelper.convert((Object)prop), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
        this.syncEventPark.post((EventObject)new PropGrantEvent(this, 1, prop.getAssetType(), after));
        return true;
    }

    @Override
    public boolean multiple(Prop prop) {
        long after;
        try {
            long value = Math.round((double)prop.propNum() * prop.multipleNum().doubleValue());
            after = this.assetService.plus(prop.getAssetType(), value, prop.getAct());
        }
        catch (Exception e) {
            log.error("multiple error: prop={}, e={}", (Object)JsonHelper.convert((Object)prop), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
        this.syncEventPark.post((EventObject)new PropGrantEvent(this, 2, prop.getAssetType(), after));
        return true;
    }
}

