/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.redeem;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.redeem.RedeemRequest;
import com.bxm.game.scene.common.core.redeem.RedeemResponse;
import com.bxm.game.scene.common.core.redeem.RedeemService;
import com.bxm.game.scene.common.core.redeem.dao.RedeemDao;
import com.bxm.game.scene.common.dal.entity.PrizeLog;
import com.bxm.game.scene.common.dal.service.IPrizeLogService;
import com.bxm.warcar.id.IdGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

@ConditionalOnBean(value={RedeemDao.class})
public class RedeemServiceImpl
implements RedeemService {
    private static final Logger log = LoggerFactory.getLogger(RedeemServiceImpl.class);
    private final int STATUS_SUBMIT = 1;
    private final IPrizeLogService iPrizeLogService;
    private final AppConfigFetcher appConfigFetcher;
    private final IdGenerator id;
    private final RedeemDao redeemDao;

    public RedeemServiceImpl(IPrizeLogService iPrizeLogService, AppConfigFetcher appConfigFetcher, IdGenerator id, RedeemDao redeemDao) {
        this.iPrizeLogService = iPrizeLogService;
        this.appConfigFetcher = appConfigFetcher;
        this.id = id;
        this.redeemDao = redeemDao;
    }

    @Override
    public void redeem(RedeemRequest request) {
        HashMap<Object, Object> attach = new HashMap<Object, Object>();
        if (!this.redeemDao.check(request, attach)) {
            return;
        }
        this.redeemDao.deduct(request, attach);
        String prizeName = this.redeemDao.getPrizeName(request, attach);
        AppContext ctx = AppContext.get();
        PrizeLog prizeLog = new PrizeLog().setOrderId(this.id.next()).setGameCode(ctx.getGameCode()).setAppId(ctx.getAppId()).setUid(ctx.getUid()).setAppUid(Optional.ofNullable(ctx.getCuid()).orElse("")).setStatus(Integer.valueOf(1)).setPrizeId(request.getPrizeId()).setPrizeName(prizeName).setPrizeNum(request.getPrizeNum()).setName(request.getName()).setMobile(request.getMobile()).setAddress(request.getAddress()).setActivityType(this.appConfigFetcher.activityType()).setPayType(Integer.valueOf(0)).setAccount("").setAmount(Integer.valueOf(0));
        this.redeemDao.handlePrizeLog(prizeLog, attach);
        try {
            if (!this.iPrizeLogService.save((Object)prizeLog)) {
                throw new GameException(DefaultErrGen.REDEEM_ERR);
            }
            log.info("PrizeLog: {}", (Object)prizeLog);
        }
        catch (Exception e) {
            log.error("save: ", (Throwable)e);
            this.redeemDao.rollback(request, attach);
            throw new GameException(DefaultErrGen.REDEEM_ERR);
        }
        this.redeemDao.notifySuccess(request, attach, prizeLog);
    }

    @Override
    public List<RedeemResponse> list() {
        QueryWrapper query = this.redeemDao.getQuery();
        if (null == query) {
            AppContext ctx = AppContext.get();
            query = Wrappers.query((Object)new PrizeLog().setGameCode(ctx.getGameCode()).setAppId(ctx.getAppId()).setUid(ctx.getUid()).setActivityType(this.appConfigFetcher.activityType()));
            query.le((Object)"amount", (Object)0);
        }
        return this.redeemDao.getResponse(this.iPrizeLogService.list(query));
    }
}

