/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene;

import com.bxm.game.scene.common.core.scene.AbstractSceneService;
import com.bxm.game.scene.common.core.scene.SceneRequest;
import com.bxm.game.scene.common.core.scene.SceneResponse;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMaximumTimesOnDailySceneService<R extends SceneRequest, T extends SceneResponse>
extends AbstractSceneService<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMaximumTimesOnDailySceneService.class);
    @Autowired
    protected TodayAtomicService todayAtomicService;

    protected String getAbortedKey(R request, Map<Object, Object> attach) {
        return this.getSceneType();
    }

    protected String getAbortedKeyForBranch(String ... codes) {
        StringBuilder sb = new StringBuilder(this.getSceneType());
        for (String code : codes) {
            sb.append('#').append(code);
        }
        return sb.toString();
    }

    protected int getMaximum(R request, Map<Object, Object> attach) {
        return 1;
    }

    @Override
    protected boolean isAbort(R request, Map<Object, Object> attach) {
        attach.put("ROLLBACK_FREQ", true);
        return this.todayAtomicService.hIncr("freq", this.getAbortedKey(request, attach), after -> after > (long)this.getMaximum(request, attach));
    }

    @Override
    protected void afterAbort(R request, Map<Object, Object> attach) {
        if (null != attach.get("ROLLBACK_FREQ")) {
            this.todayAtomicService.hIncrBy("freq", this.getAbortedKey(request, attach), -1L);
        }
    }
}

