/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene;

import com.alibaba.fastjson.JSONObject;
import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropGrantor;
import com.bxm.game.scene.common.core.scene.SceneRequest;
import com.bxm.game.scene.common.core.scene.SceneResponse;
import com.bxm.game.scene.common.core.scene.SceneService;
import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSceneService<R extends SceneRequest, T extends SceneResponse>
implements SceneService<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSceneService.class);
    @Autowired
    private IdGenerator id;
    @Autowired
    private SyncEventPark syncEventPark;
    @Autowired
    private PropGrantor grantor;
    @Autowired
    private AppConfigFetcher appConfigFetcher;

    protected boolean isRequiredRequest() {
        return false;
    }

    protected boolean isAbort(R request, Map<Object, Object> attach) {
        return false;
    }

    protected String createId(R request) {
        return this.id.next();
    }

    protected abstract Prop takeProp(R var1, Map<Object, Object> var2);

    protected abstract T createResponse(R var1, String var2, Prop var3, Map<Object, Object> var4);

    protected void afterAbort(R request, Map<Object, Object> attach) {
    }

    protected void afterTake(R request, Prop prop) {
    }

    protected void beforePostEvent(R request, T response, Prop prop, Map<Object, Object> attach) {
    }

    protected void afterCompletion(R request, T response, Prop prop, Map<Object, Object> attach) {
    }

    @Override
    public T take(R request) {
        if (this.isRequiredRequest() && Objects.isNull(request)) {
            throw new GameException(DefaultErrGen.BAD_REQUEST);
        }
        boolean isBizLog = this.appConfigFetcher.isBizLog();
        HashMap attach = Maps.newHashMap();
        if (this.doIsAbort(request, attach, isBizLog)) {
            if (isBizLog) {
                log.warn("{} [isAbort] Returns 'true': appContext={},request={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request)});
            }
            this.doAfterAbort(request, attach, isBizLog);
            throw new GameException(DefaultErrGen.CONDITION_LIMIT);
        }
        Prop prop = this.doTakeProp(request, attach, isBizLog);
        if (Objects.isNull(prop)) {
            this.doAfterAbort(request, attach, isBizLog);
            throw new GameException(DefaultErrGen.NOT_TAKE_PROP);
        }
        this.afterTake(request, prop);
        String id = this.createId(request);
        T response = this.createResponse(request, id, prop, attach);
        if (Objects.isNull(response)) {
            log.error("{} createResponse is null: appContext={},request={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        ((SceneResponse)response).setId(id);
        ((SceneResponse)response).setAssetType(prop.getAssetType());
        ((SceneResponse)response).setPropNum(prop.propNum());
        ((SceneResponse)response).setAcquired(prop.acquired());
        ((SceneResponse)response).setMultipleNum(prop.multipleNum());
        ((SceneResponse)response).setStartAcquireTime(prop.startAcquireTime());
        ((SceneResponse)response).setEndAcquireTime(prop.endAcquireTime());
        boolean isMultiple = this.isMultipleGrant();
        if (!this.grantor.grant(prop, isMultiple) && prop.acquired()) {
            throw new GameException(DefaultErrGen.GRANT_PROP_FAIL);
        }
        this.beforePostEvent(request, response, prop, attach);
        this.syncEventPark.post((EventObject)new AcquiredPropEvent(this, id, this.getSceneType(), prop, isMultiple, attach, (SceneRequest)request, (SceneResponse)response));
        this.afterCompletion(request, response, prop, attach);
        return response;
    }

    private boolean doIsAbort(R request, Map<Object, Object> attach, boolean isBizLog) {
        try {
            return this.isAbort(request, attach);
        }
        catch (GameException e) {
            if (isBizLog) {
                log.warn("{} [doIsAbort] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), JsonHelper.convert((Object)e.getErrCode())});
            }
            throw e;
        }
        catch (Exception e) {
            log.error("{} [doIsAbort] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), ExceptionUtils.getStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
    }

    private void doAfterAbort(R request, Map<Object, Object> attach, boolean isBizLog) {
        try {
            this.afterAbort(request, attach);
        }
        catch (GameException e) {
            if (isBizLog) {
                log.warn("{} [afterAbort] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), JsonHelper.convert((Object)e.getErrCode())});
            }
            throw e;
        }
        catch (Exception e) {
            log.error("{} [afterAbort] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), ExceptionUtils.getStackTrace((Throwable)e)});
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
    }

    private Prop doTakeProp(R request, Map<Object, Object> attach, boolean isBizLog) {
        Prop prop;
        try {
            prop = this.takeProp(request, attach);
        }
        catch (GameException e) {
            if (isBizLog) {
                log.warn("{} [takeProp] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), JsonHelper.convert((Object)e.getErrCode())});
            }
            throw e;
        }
        catch (Exception e) {
            log.error("{} [takeProp] error: appContext={},request={},e={}", new Object[]{this.getClass(), JsonHelper.convert((Object)AppContext.getInstance()), JsonHelper.convert(request), ExceptionUtils.getStackTrace((Throwable)e)});
            this.doAfterAbort(request, attach, isBizLog);
            throw new GameException(DefaultErrGen.INTERNAL_SERVER_ERROR);
        }
        return prop;
    }

    @Override
    public R convert(String message) {
        if (StringUtils.isBlank((String)message)) {
            try {
                return (R)((SceneRequest)this.getRequestClass().newInstance());
            }
            catch (Exception e) {
                return null;
            }
        }
        return (R)((SceneRequest)JsonHelper.convert((String)message, this.getRequestClass()));
    }

    @Override
    public List<R> convertList(String message) {
        if (StringUtils.isBlank((String)message)) {
            return null;
        }
        return JSONObject.parseArray((String)message, this.getRequestClass());
    }

    protected SyncEventPark getSyncEventPark() {
        return this.syncEventPark;
    }
}

