/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene;

import com.bxm.game.scene.common.core.scene.SceneService;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class SceneServiceFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SceneServiceFactory.class);
    private final Map<String, SceneService> map = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansOfType(SceneService.class);
        for (SceneService service : beans.values()) {
            this.map.put(service.getSceneType(), service);
            log.info("Registering SceneService to Factory: {}", (Object)service);
        }
    }

    public SceneService get(String sceneType) {
        return this.map.get(sceneType);
    }
}

