/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene.acquire;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropBuilder;
import com.bxm.game.scene.common.core.prop.PropService;
import com.bxm.game.scene.common.core.scene.AbstractSceneService;
import com.bxm.game.scene.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.scene.common.core.scene.acquire.AcquireConditional;
import com.bxm.game.scene.common.core.scene.acquire.AcquireSceneRequest;
import com.bxm.game.scene.common.core.scene.acquire.AcquireSceneResponse;
import com.bxm.game.scene.common.core.scene.acquire.AcquiredSceneEvent;
import com.bxm.game.scene.common.core.user.TemporaryAtomicService;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class AcquireSceneServiceImpl
extends AbstractSceneService<AcquireSceneRequest, AcquireSceneResponse>
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(AcquireSceneServiceImpl.class);
    private final Map<String, AcquireConditional> condtionalMap = Maps.newHashMap();
    private final PropService propService;
    private final TemporaryAtomicService temporaryAtomicService;
    private final PropBuilder propBuilder;

    public AcquireSceneServiceImpl(PropService propService, TemporaryAtomicService temporaryAtomicService, PropBuilder propBuilder) {
        this.propService = propService;
        this.temporaryAtomicService = temporaryAtomicService;
        this.propBuilder = propBuilder;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map beans = event.getApplicationContext().getBeansOfType(AcquireConditional.class);
        for (Map.Entry e : beans.entrySet()) {
            AcquireConditional bean = (AcquireConditional)e.getValue();
            String conditionSceneType = bean.getSceneType();
            this.condtionalMap.put(conditionSceneType, bean);
            log.info("Registered AcquireConditional bean: {}", (Object)bean);
        }
    }

    @Override
    protected String createId(AcquireSceneRequest request) {
        return request.getId();
    }

    @Override
    protected Prop takeProp(AcquireSceneRequest request, Map<Object, Object> attach) {
        if (Objects.isNull(request)) {
            return null;
        }
        String appId = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();
        String id = request.getId();
        String barrier = this.getSceneType() + id;
        if (this.temporaryAtomicService.incrAndAbove(barrier, 1L)) {
            throw new GameException(DefaultErrGen.NOT_MEET_ACQUIRING_CONDITION);
        }
        AcquiredPropLog takeLog = this.propService.getTakeLog(id);
        if (Objects.isNull(takeLog)) {
            return null;
        }
        if (!StringUtils.equals((String)appId, (String)takeLog.getAppId()) || !StringUtils.equals((String)uid, (String)takeLog.getUid()) || takeLog.isAcquired() || !takeLog.isBetweenAcquireTime()) {
            return null;
        }
        if (this.condtionalMap.containsKey(takeLog.getSceneType()) && !this.condtionalMap.get(takeLog.getSceneType()).checked(takeLog)) {
            this.temporaryAtomicService.incrBy(barrier, -1L);
            throw new GameException(DefaultErrGen.NOT_MEET_ACQUIRING_CONDITION);
        }
        Prop prop = this.propBuilder.rebuild(takeLog.getAssetType(), takeLog.getPropNum(), takeLog.getMultipleNum(), takeLog.getAct(), takeLog.getSceneType());
        if (Objects.nonNull(prop)) {
            this.propService.saveTakeLog(takeLog.setAcquired(true));
        }
        return prop;
    }

    @Override
    protected void afterCompletion(AcquireSceneRequest request, AcquireSceneResponse response, Prop prop, Map<Object, Object> attach) {
        this.getSyncEventPark().post((EventObject)new AcquiredSceneEvent(this, request, response, prop.getSceneType()));
        this.getSyncEventPark().post((EventObject)new AcquiringOrMultiplyPropEvent(this, request, response, prop.getSceneType(), this.getSceneType()));
    }

    @Override
    protected AcquireSceneResponse createResponse(AcquireSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        return new AcquireSceneResponse();
    }

    @Override
    public String getSceneType() {
        return "acquire";
    }

    @Override
    public Class<AcquireSceneRequest> getRequestClass() {
        return AcquireSceneRequest.class;
    }
}

