/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene.advance;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropBuilder;
import com.bxm.game.scene.common.core.prop.PropService;
import com.bxm.game.scene.common.core.scene.AbstractSceneService;
import com.bxm.game.scene.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.scene.common.core.scene.advance.AdvanceConditional;
import com.bxm.game.scene.common.core.scene.advance.AdvanceSceneEvent;
import com.bxm.game.scene.common.core.scene.advance.AdvanceSceneRequest;
import com.bxm.game.scene.common.core.scene.advance.AdvanceSceneResponse;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class AdvanceSceneServiceImpl
extends AbstractSceneService<AdvanceSceneRequest, AdvanceSceneResponse>
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdvanceSceneServiceImpl.class);
    private final Map<String, AdvanceConditional> conditionalMap = Maps.newHashMap();
    private final PropService propService;
    private final PropBuilder propBuilder;

    public AdvanceSceneServiceImpl(PropService propService, PropBuilder propBuilder) {
        this.propService = propService;
        this.propBuilder = propBuilder;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map beans = event.getApplicationContext().getBeansOfType(AdvanceConditional.class);
        for (Map.Entry e : beans.entrySet()) {
            AdvanceConditional bean = (AdvanceConditional)e.getValue();
            String conditionSceneType = bean.getSceneType();
            this.conditionalMap.put(conditionSceneType, bean);
            log.info("Registered AdvanceConditional bean: {}", (Object)bean);
        }
    }

    @Override
    protected Prop takeProp(AdvanceSceneRequest request, Map<Object, Object> attach) {
        if (Objects.isNull(request) || request.getPropNum() <= 0) {
            return null;
        }
        String appId = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();
        String id = request.getId();
        AcquiredPropLog takeLog = this.propService.getTakeLog(id);
        if (Objects.isNull(takeLog)) {
            return null;
        }
        if (!StringUtils.equals((String)appId, (String)takeLog.getAppId()) || !StringUtils.equals((String)uid, (String)takeLog.getUid()) || takeLog.isAcquired() || !takeLog.isBetweenAcquireTime()) {
            return null;
        }
        AdvanceConditional conditional = this.conditionalMap.get(takeLog.getSceneType());
        if (null == conditional) {
            throw new GameException(DefaultErrGen.NOT_MEET_ACQUIRING_CONDITION);
        }
        int propNum = conditional.getPropNum(takeLog, request);
        if (propNum <= 0) {
            throw new GameException(DefaultErrGen.NOT_MEET_ACQUIRING_CONDITION);
        }
        int remainPropNum = takeLog.getPropNum() - propNum;
        if (remainPropNum > 0) {
            takeLog.setPropNum(remainPropNum);
        } else {
            takeLog.setAcquired(true);
        }
        Prop prop = this.propBuilder.rebuild(takeLog.getAssetType(), propNum, takeLog.getMultipleNum(), takeLog.getAct(), takeLog.getSceneType());
        if (Objects.nonNull(prop)) {
            this.propService.saveTakeLog(takeLog);
        }
        return prop;
    }

    @Override
    protected void afterCompletion(AdvanceSceneRequest request, AdvanceSceneResponse response, Prop prop, Map<Object, Object> attach) {
        this.getSyncEventPark().post((EventObject)new AdvanceSceneEvent(this, request, response, prop.getSceneType()));
        this.getSyncEventPark().post((EventObject)new AcquiringOrMultiplyPropEvent(this, request, response, prop.getSceneType(), this.getSceneType()));
    }

    @Override
    protected AdvanceSceneResponse createResponse(AdvanceSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        return new AdvanceSceneResponse();
    }

    @Override
    public String getSceneType() {
        return "advance";
    }

    @Override
    public Class<AdvanceSceneRequest> getRequestClass() {
        return AdvanceSceneRequest.class;
    }
}

