/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene.base.continuous;

import com.bxm.game.scene.common.core.bean.enums.ContinuousSigninRoundTypeEnum;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.scene.AbstractMaximumTimesOnDailySceneService;
import com.bxm.game.scene.common.core.scene.SceneRequest;
import com.bxm.game.scene.common.core.scene.base.continuous.BaseContinuousConfigService;
import com.bxm.game.scene.common.core.scene.base.continuous.BaseContinuousSceneRequest;
import com.bxm.game.scene.common.core.scene.base.continuous.BaseContinuousSceneResponse;
import com.bxm.game.scene.common.core.scene.base.continuous.BaseContinuousService;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.utils.DateHelper;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContinuousSceneServiceImpl<R extends BaseContinuousSceneRequest, T extends BaseContinuousSceneResponse>
extends AbstractMaximumTimesOnDailySceneService<R, T>
implements BaseContinuousService<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractContinuousSceneServiceImpl.class);
    protected final BaseContinuousConfigService continuousConfigService;
    protected final DefaultTimeBoundService defaultTimeBoundService;
    protected final int maxDays;
    protected final int ttl;

    public AbstractContinuousSceneServiceImpl(BaseContinuousConfigService continuousConfigService, DefaultTimeBoundService defaultTimeBoundService) {
        this.continuousConfigService = continuousConfigService;
        this.defaultTimeBoundService = defaultTimeBoundService;
        this.maxDays = continuousConfigService.getMaxDays(this.getSceneType());
        if (this.maxDays < 1) {
            throw new RuntimeException("'maxDays' < 1");
        }
        this.ttl = 86400 * this.maxDays;
    }

    @Override
    protected final int getMaximum(R request, Map<Object, Object> attach) {
        return super.getMaximum(request, attach);
    }

    @Override
    public int getContinuousDays() {
        long days = this.defaultTimeBoundService.hGet("sign", this.getSceneType());
        if (days >= (long)this.maxDays) {
            return this.todayDone() ? this.maxDays : 0;
        }
        Date currentDate = new Date();
        String ymd = DateHelper.convertDateToString((Date)currentDate, (String)"yyyyMMdd");
        String last = this.defaultTimeBoundService.hGet("sign", this.continuousConfigService.getFieldLast(this.getSceneType()), String.class);
        Date ymdDate = DateHelper.convertStringToDate((String)ymd, (String)"yyyyMMdd");
        Date lastDate = DateHelper.convertStringToDate((String)last, (String)"yyyyMMdd");
        if (null == lastDate) {
            return 0;
        }
        if (CommonHelper.orderDays(lastDate, ymdDate) > 2) {
            return 0;
        }
        return (int)days;
    }

    @Override
    public int getContinuousRounds() {
        long round = this.defaultTimeBoundService.hGet("freq", this.continuousConfigService.getFieldRound(this.getSceneType()));
        if (round < 1L) {
            return 1;
        }
        Date currentDate = new Date();
        String ymd = DateHelper.convertDateToString((Date)currentDate, (String)"yyyyMMdd");
        String last = this.defaultTimeBoundService.hGet("sign", "signinLast", String.class);
        Date ymdDate = DateHelper.convertStringToDate((String)ymd, (String)"yyyyMMdd");
        Date lastDate = DateHelper.convertStringToDate((String)last, (String)"yyyyMMdd");
        if (null == lastDate) {
            return this.getRounds(round, ContinuousSigninRoundTypeEnum.FIRST);
        }
        if (CommonHelper.orderDays(lastDate, ymdDate) > 2) {
            return this.getRounds(round, ContinuousSigninRoundTypeEnum.BREAK);
        }
        long days = this.defaultTimeBoundService.hGet("sign", this.getSceneType());
        if (days >= (long)this.maxDays && !this.todayDone()) {
            return this.getRounds(round, ContinuousSigninRoundTypeEnum.NEXT);
        }
        return (int)round;
    }

    @Override
    public boolean todayDone() {
        return this.todayAtomicService.hGet("freq", this.getSceneType()) > 0L;
    }

    @Override
    protected boolean isAbort(R request, Map<Object, Object> attach) {
        Date currentDate = new Date();
        String ymd = DateHelper.convertDateToString((Date)currentDate, (String)"yyyyMMdd");
        String last = this.defaultTimeBoundService.hGet("sign", this.continuousConfigService.getFieldLast(this.getSceneType()), String.class);
        if (null != last && last.compareTo(ymd) == 1) {
            return true;
        }
        attach.put("F_1", ymd);
        attach.put("F_2", last);
        return super.isAbort(request, attach);
    }

    @Override
    protected Prop takeProp(R request, Map<Object, Object> attach) {
        int days;
        String ymd = (String)attach.get("F_1");
        String last = (String)attach.get("F_2");
        Date ymdDate = DateHelper.convertStringToDate((String)ymd, (String)"yyyyMMdd");
        Date lastDate = DateHelper.convertStringToDate((String)last, (String)"yyyyMMdd");
        String sceneType = this.getSceneType();
        if (null == lastDate) {
            days = 1;
            this.defaultTimeBoundService.hSet("sign", sceneType, (Object)String.valueOf(days), this.ttl);
            this.addRounds(sceneType, ContinuousSigninRoundTypeEnum.FIRST);
        } else if (CommonHelper.orderDays(lastDate, ymdDate) > 2) {
            days = 1;
            this.defaultTimeBoundService.hSet("sign", sceneType, (Object)String.valueOf(days), this.ttl);
            this.addRounds(sceneType, ContinuousSigninRoundTypeEnum.BREAK);
        } else {
            days = (int)this.defaultTimeBoundService.hIncr("sign", sceneType, this.ttl);
            if (days > this.maxDays) {
                long minus = days - 1;
                days = 1;
                if (this.defaultTimeBoundService.hIncrBy("sign", sceneType, -minus, this.ttl) < 1L) {
                    this.defaultTimeBoundService.hIncrBy("sign", sceneType, minus, this.ttl);
                }
                this.addRounds(sceneType, ContinuousSigninRoundTypeEnum.NEXT);
            }
        }
        this.defaultTimeBoundService.hSet("sign", this.continuousConfigService.getFieldLast(sceneType), (Object)ymd, this.ttl);
        attach.put("F_3", days);
        return this.continuousConfigService.getProps(sceneType, ((SceneRequest)request).getAcquired(), days);
    }

    protected void addRounds(String sceneType, ContinuousSigninRoundTypeEnum roundTypeEnum) {
        if (ContinuousSigninRoundTypeEnum.FIRST == roundTypeEnum) {
            this.defaultTimeBoundService.hSet("freq", this.continuousConfigService.getFieldRound(sceneType), (Object)String.valueOf(1));
        } else if (ContinuousSigninRoundTypeEnum.BREAK == roundTypeEnum) {
            this.defaultTimeBoundService.hIncr("freq", this.continuousConfigService.getFieldRound(sceneType));
        }
        if (ContinuousSigninRoundTypeEnum.NEXT == roundTypeEnum) {
            this.defaultTimeBoundService.hIncr("freq", this.continuousConfigService.getFieldRound(sceneType));
        }
    }

    protected int getRounds(long round, ContinuousSigninRoundTypeEnum roundTypeEnum) {
        if (ContinuousSigninRoundTypeEnum.FIRST == roundTypeEnum) {
            round = 1L;
        } else if (ContinuousSigninRoundTypeEnum.BREAK == roundTypeEnum) {
            ++round;
        }
        if (ContinuousSigninRoundTypeEnum.NEXT == roundTypeEnum) {
            ++round;
        }
        return (int)round;
    }

    @Override
    public int getTodayDays() {
        int days = this.getContinuousDays();
        if (!this.todayDone()) {
            ++days;
        }
        if (days > this.maxDays) {
            days = 1;
        }
        return days;
    }
}

