/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene.base.week;

import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.scene.AbstractMaximumTimesOnDailySceneService;
import com.bxm.game.scene.common.core.scene.SceneRequest;
import com.bxm.game.scene.common.core.scene.base.week.BaseWeekSceneRequest;
import com.bxm.game.scene.common.core.scene.base.week.BaseWeekSceneResponse;
import com.bxm.game.scene.common.core.scene.base.week.BaseWeekService;
import com.bxm.game.scene.common.core.scene.signin.week.WeekSigninConfigService;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.util.WeekCNHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWeekSceneServiceImpl<R extends BaseWeekSceneRequest, T extends BaseWeekSceneResponse>
extends AbstractMaximumTimesOnDailySceneService<R, T>
implements BaseWeekService<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractWeekSceneServiceImpl.class);
    protected final WeekSigninConfigService signinConfigService;
    protected final DefaultTimeBoundService defaultTimeBoundService;
    protected final int ttl;

    public AbstractWeekSceneServiceImpl(WeekSigninConfigService signinConfigService, DefaultTimeBoundService defaultTimeBoundService) {
        this.signinConfigService = signinConfigService;
        this.defaultTimeBoundService = defaultTimeBoundService;
        this.ttl = 604800;
    }

    @Override
    protected boolean isAbort(R request, Map<Object, Object> attach) {
        String fieldName;
        long count;
        int days;
        String sceneType = this.getSceneType();
        Date currentDate = new Date();
        int daysOfWeek = WeekCNHelper.orderDaysOfWeek(currentDate);
        if (null != request && null != ((BaseWeekSceneRequest)request).getDays()) {
            if (((BaseWeekSceneRequest)request).getDays() < 1) {
                ((BaseWeekSceneRequest)request).setDays(1);
            } else if (((BaseWeekSceneRequest)request).getDays() > 7) {
                ((BaseWeekSceneRequest)request).setDays(7);
            }
            if (((BaseWeekSceneRequest)request).getDays() > daysOfWeek) {
                return true;
            }
            days = ((BaseWeekSceneRequest)request).getDays();
        } else {
            days = daysOfWeek;
        }
        attach.put("F_1", days);
        String weekOfYear = WeekCNHelper.getWeekOfYear(currentDate);
        String week = this.defaultTimeBoundService.hGet("sign", this.signinConfigService.getFieldWeek(sceneType), String.class);
        if (null == week || !week.equals(weekOfYear)) {
            this.resetSign(weekOfYear, sceneType);
        }
        if ((count = this.defaultTimeBoundService.hIncrBy("sign", fieldName = this.getField(sceneType, String.valueOf(days)), 1L, this.ttl)) > (long)this.getMaximum(request, attach)) {
            this.defaultTimeBoundService.hIncrBy("sign", fieldName, -1L, this.ttl);
            return true;
        }
        return false;
    }

    @Override
    protected Prop takeProp(R request, Map<Object, Object> attach) {
        int days = (Integer)attach.get("F_1");
        return this.signinConfigService.getProps(this.getSceneType(), ((SceneRequest)request).getAcquired(), days);
    }

    private void resetSign(String weekOfYear, String sceneType) {
        this.defaultTimeBoundService.hSet("sign", this.signinConfigService.getFieldWeek(sceneType), (Object)weekOfYear, this.ttl);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= 7; ++i) {
            list.add(this.getField(sceneType, String.valueOf(i)));
        }
        this.defaultTimeBoundService.hDel("sign", list.toArray(new String[0]));
    }

    protected String getField(String mark, String days) {
        return mark + '_' + days;
    }

    @Override
    public boolean todayDone() {
        int daysOfWeek;
        Date currentDate = new Date();
        String sceneType = this.getSceneType();
        Map<String, String> sigins = this.getSignMap(sceneType);
        int count = Integer.valueOf(Optional.ofNullable(sigins.get(this.getField(sceneType, String.valueOf(daysOfWeek = WeekCNHelper.orderDaysOfWeek(currentDate))))).orElse("0"));
        return count > 0;
    }

    @Override
    public Map<Integer, Integer> getAll() {
        HashMap<Integer, Integer> res = new HashMap<Integer, Integer>();
        String sceneType = this.getSceneType();
        Map<String, String> sigins = this.getSignMap(sceneType);
        for (int days = 1; days < 8; ++days) {
            int count = Integer.valueOf(Optional.ofNullable(sigins.get(this.getField(sceneType, String.valueOf(days)))).orElse("0"));
            res.put(days, count > 0 ? count : 0);
        }
        return res;
    }

    private Map<String, String> getSignMap(String sceneType) {
        Map<String, String> sigins = this.defaultTimeBoundService.hGetAll("sign", String.class);
        if (null == sigins) {
            sigins = new HashMap<String, String>();
        } else {
            Date currentDate = new Date();
            String weekOfYear = WeekCNHelper.getWeekOfYear(currentDate);
            String week = sigins.get(this.signinConfigService.getFieldWeek(sceneType));
            if (null == week || !week.equals(weekOfYear)) {
                this.resetSign(weekOfYear, sceneType);
                sigins = new HashMap<String, String>();
            }
        }
        return sigins;
    }
}

